////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import java.io.*;
import javax.microedition.lcdui.*;

public class ItemObject extends LevelObject implements Collidable
{
    public static final int ITEM_GRAVITY_DIR = 0;
    public static final int ITEM_COLLECTIBLE = 1;
    
    private static final int RADIUS = FP.toFP(1.0f);
    private static final int HIT_RADIUS = 2*RADIUS/4;
    private static final int HIT_RADIUS2 = FP.mul( HIT_RADIUS, HIT_RADIUS );
    
    private static final int ARROW_LEN = FP.toFP(0.7f);
    private static final int ARROW_SIDE = FP.toFP(0.45f);
    private static final int ARROW_MOVE = FP.toFP(0.4f);
    
    public int pos_x, pos_y;
    public int type;
    
    // FOR GRAVITY DIR ITEM
    private int m_gravity_dir;
    private int m_gravity_bounce;
    
    // FOR COLLECTIBLE ITEM
    private static final int g_collectible_mesh_scale = FP.toFP( 0.1f );
    private static int[] g_collectible_mesh_cache;
    private boolean m_collected;
    private Mesh m_collectible_mesh;
    private int m_collectible_mesh_angle;
    
    /**
     * Returns the item type.
     * 
     * @return Returns the item type.
     */
    public int getType()
    {
        return type;
    }
    
    /**
     * Updates the level object.
     * 
     * @param time_secs
     */
    public void update( int time_secs )
    {
        // Gravity
        m_gravity_bounce += time_secs * 3;
        while ( m_gravity_bounce >= FP.PI2 )
            m_gravity_bounce -= FP.PI2;
        
        // Collectible
        m_collectible_mesh_angle = m_gravity_bounce;
    }

    /**
     * Renders the level object.
     */
    public void render( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        switch ( type )
        {
        case ITEM_GRAVITY_DIR:      renderGravity( g, top_x, top_y, scale_x, scale_y ); break;
        case ITEM_COLLECTIBLE:      renderCollectible( g, top_x, top_y, scale_x, scale_y ); break;
        }
    }
    
    private void renderGravity( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        int cx = FP.mul(pos_x - top_x, scale_x);
        int cy = FP.mul(pos_y - top_y, scale_y);

        // Arrow movement
        int move_sin = Math.abs(FP.sin(m_gravity_bounce));
        int move_amt = (ARROW_MOVE/2) - FP.mul( move_sin, ARROW_MOVE );
        move_amt = FP.mul( move_amt, scale_x );
        
        // Get the arrow dir
        int dx = 0, dy = 0;
        int nx = 0, ny = 0;
        switch ( m_gravity_dir )
        {
        case Level.DIR_LEFT:    dx = FP.mul( -ARROW_LEN, scale_x ); ny = FP.mul( -ARROW_SIDE, scale_x ); cx -= move_amt; break;
        case Level.DIR_RIGHT:   dx = FP.mul(  ARROW_LEN, scale_x ); ny = FP.mul(  ARROW_SIDE, scale_x ); cx += move_amt; break;
        case Level.DIR_UP:      dy = FP.mul( -ARROW_LEN, scale_y ); nx = FP.mul(  ARROW_SIDE, scale_y ); cy -= move_amt; break;
        case Level.DIR_DOWN:    dy = FP.mul(  ARROW_LEN, scale_y ); nx = FP.mul( -ARROW_SIDE, scale_y ); cy += move_amt; break;
        default:                return;
        }
        
        // Draw the arrow
        if ( level.gravity_dir == m_gravity_dir )
            g.setColor( 0xff555555 );
        else
        {
            int c = 0x44 + FP.toInt((0xff-0x44) * move_sin);
            g.setColor( 0xff000000 | (c<<16) | (c<<8) );
        }
        g.fillTriangle(
                FP.toInt( cx + dx ), FP.toInt( cy + dy ),
                FP.toInt( cx - dx + nx ), FP.toInt( cy - dy + ny ),
                FP.toInt( cx - dx - nx ), FP.toInt( cy - dy - ny ) );
    }
    
    private void renderCollectible( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        if ( m_collected )
            return;
        
        if ( m_collectible_mesh != null )
        {
            g_collectible_mesh_cache = m_collectible_mesh.render( g, g_collectible_mesh_scale, m_collectible_mesh_angle, pos_x - top_x, pos_y - top_y, scale_x, scale_y, g_collectible_mesh_cache );
        }
    }
    
    /**
     * Loads the object from the stream.
     * 
     * @param in The data stream.
     * @throws IOException
     */
    public void load(DataInputStream in) throws IOException
    {
        // Read the position
        pos_x = in.readInt();
        pos_y = in.readInt();
        
        // Read the type
        type = in.readByte();
        
        // Read the gravity direction
        m_gravity_dir = in.readByte();
        
        // Get the meshes
        if ( type == ITEM_COLLECTIBLE )
            m_collectible_mesh = Res.meshes.find( "star" );
    }

    /**
     * Resolves a possible verlet collision.
     * 
     * @param v The verlet.
     */
    public void resolveCollision( Verlet v )
    {
        if ( type == ITEM_GRAVITY_DIR &&
             level.gravity_dir == m_gravity_dir)
            return;
        if ( type == ITEM_COLLECTIBLE && m_collected )
            return;
        
        // BBox test
        int dx = v.pos[0] - pos_x;
        int dy = v.pos[1] - pos_y;
        if (Math.abs(dx) >= HIT_RADIUS || Math.abs(dy) >= HIT_RADIUS)
            return;
        
        // Distance test
        int dist2 = FP.mul( dx, dx ) + FP.mul( dy, dy );
        if (dist2 >= HIT_RADIUS2)
            return;
        
        // Set the new gravity?
        if ( type == ITEM_GRAVITY_DIR )
        {
            level.setGravity( m_gravity_dir );

            // Play the sound
            Res.audio.playSound( Res.audio.sound_grav );
        }
        
        // Collect?
        if ( type == ITEM_COLLECTIBLE )
        {
            m_collected = true;
            level.collectibles_left -= 1;

            // Play the sound
            Res.audio.playSound( Res.audio.sound_item );
        }
    }
}
