/*
 * Decompiled with CFR 0.152.
 */
public final class Vec2 {
    public static final int[] create() {
        return Vec2.create(0, 0);
    }

    public static final int[] create(int x, int y) {
        return new int[]{x, y};
    }

    public static final void set(int[] vec, int x, int y) {
        vec[0] = x;
        vec[1] = y;
    }

    public static final void set(int[] vec, int[] src) {
        vec[0] = src[0];
        vec[1] = src[1];
    }

    public static final void getInt(int[] dest, int[] vec) {
        dest[0] = FP.toInt(vec[0]);
        dest[1] = FP.toInt(vec[1]);
    }

    public static final void getScaledInt(int[] dest, int[] vec, int top_x, int top_y, int scale_x, int scale_y) {
        dest[0] = FP.toInt(FP.mul(vec[0] - top_x, scale_x));
        dest[1] = FP.toInt(FP.mul(vec[1] - top_y, scale_y));
    }

    public static final void makeNormal(int[] vec) {
        int x = vec[0];
        int y = vec[1];
        vec[0] = -y;
        vec[1] = x;
    }

    public static final void addScaled(int[] dest, int[] a, int[] b, int b_scale) {
        dest[0] = a[0] + FP.mul(b[0], b_scale);
        dest[1] = a[1] + FP.mul(b[1], b_scale);
    }

    public static final void add(int[] dest, int[] src) {
        dest[0] = dest[0] + src[0];
        dest[1] = dest[1] + src[1];
    }

    public static final void add(int[] dest, int[] a, int[] b) {
        dest[0] = a[0] + b[0];
        dest[1] = a[1] + b[1];
    }

    public static final void sub(int[] dest, int[] src) {
        dest[0] = dest[0] - src[0];
        dest[1] = dest[1] - src[1];
    }

    public static final void sub(int[] dest, int[] a, int[] b) {
        dest[0] = a[0] - b[0];
        dest[1] = a[1] - b[1];
    }

    public static final void scale(int[] dest, int mul) {
        dest[0] = FP.mul(dest[0], mul);
        dest[1] = FP.mul(dest[1], mul);
    }

    public static final void lerp(int[] dest, int[] vec1, int[] vec2, int t) {
        dest[0] = vec1[0] + FP.mul(t, vec2[0] - vec1[0]);
        dest[1] = vec1[1] + FP.mul(t, vec2[1] - vec1[1]);
    }

    public static final int length(int[] vec) {
        return FP.sqrt(FP.mul(vec[0], vec[0]) + FP.mul(vec[1], vec[1]));
    }

    public static final int dot(int[] v1, int[] v2) {
        return FP.mul(v1[0], v2[0]) + FP.mul(v1[1], v2[1]);
    }

    public static final int dist(int[] v1, int[] v2) {
        int p0 = v2[0] - v1[0];
        int p1 = v2[1] - v1[1];
        return FP.sqrt(FP.mul(p0, p0) + FP.mul(p1, p1));
    }

    public static final int normalize(int[] vec) {
        int len = Vec2.length(vec);
        if (len <= 0) {
            Vec2.set(vec, 0, 0);
            return 0;
        }
        vec[0] = FP.div(vec[0], len);
        vec[1] = FP.div(vec[1], len);
        return len;
    }

    public static String toString(int[] vec) {
        return "(" + FP.toString(vec[0]) + ", " + FP.toString(vec[1]) + ")";
    }

    private Vec2() {
    }
}

