/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Meshes {
    public Mesh[] meshes;

    public Meshes() {
        if (Res.editor_mesh_data != null) {
            this.init(Res.editor_mesh_data);
        } else {
            this.init("/msh");
        }
    }

    public Mesh find(int id) {
        int i = 0;
        while (i < this.meshes.length) {
            if (this.meshes[i].id == id) {
                return this.meshes[i];
            }
            ++i;
        }
        return null;
    }

    public Mesh find(String name) {
        int i = 0;
        while (i < this.meshes.length) {
            if (name.equals(this.meshes[i].name)) {
                return this.meshes[i];
            }
            ++i;
        }
        return null;
    }

    private void init(byte[] data) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            this.init(new DataInputStream(in));
            ((InputStream)in).close();
        }
        catch (Throwable t) {
            throw new Error("Error loading the meshes: " + t);
        }
    }

    private void init(String fname) {
        try {
            InputStream in = Res.getResourceAsStream(fname);
            this.init(new DataInputStream(in));
            in.close();
        }
        catch (Throwable t) {
            throw new Error("Error loading the meshes: " + t);
        }
    }

    private void init(DataInputStream in) throws IOException {
        int amt = in.readShort();
        this.meshes = new Mesh[amt];
        int i = 0;
        while (i < amt) {
            Mesh m;
            this.meshes[i] = m = new Mesh();
            m.id = in.readInt();
            m.name = in.readUTF();
            int points = in.readShort();
            m.point_data = new int[points * 2];
            m.point_temp = new int[points * 2];
            int j = 0;
            while (j < points) {
                m.point_data[j * 2 + 0] = in.readInt();
                m.point_data[j * 2 + 1] = in.readInt();
                ++j;
            }
            int faces = in.readShort();
            m.face_data = new int[faces * 4];
            int j2 = 0;
            while (j2 < faces) {
                m.face_data[j2 * 4 + 0] = in.readInt();
                m.face_data[j2 * 4 + 1] = in.readShort();
                m.face_data[j2 * 4 + 2] = in.readShort();
                m.face_data[j2 * 4 + 3] = in.readShort();
                ++j2;
            }
            ++i;
        }
    }
}

