using System;
using System.Collections.Generic;
using System.Globalization;
using System.Security.Cryptography;
using System.Text;
using System.Xml;

namespace StarifficEditor
{
    public sealed class TextUtil
    {
		public static float ParseFloat(String str, float def_val)
		{
			try
			{
                return System.Convert.ToSingle(str.Replace(',', '.'), NumberFormatInfo.InvariantInfo);
			}
			catch (Exception)
			{
				return def_val;
			}
		}

        public static String GetString(XmlElement elem, String name, String def_val)
        {
            try
            {
                String ret = elem.GetAttribute(name);
                return (ret != null) ? ret : def_val;
            }
            catch (Exception)
            {
                return def_val;
            }
        }

		public static int GetInt(XmlElement elem, String name, int def_val)
		{
			try { return int.Parse(GetString(elem, name, null)); }
			catch (Exception) { return def_val; }
		}

		public static float GetFloat(XmlElement elem, String name, float def_val)
		{
			try { return ParseFloat(GetString(elem, name, null), def_val); }
			catch (Exception) { return def_val; }
		}

        public static T GetEnum<T>(XmlElement elem, String name, T def_val)
        {
            try { return (T) Enum.Parse(typeof(T), GetString(elem, name, null), true); }
            catch (Exception) { return def_val; }
        }

        public static void AddStringElement(XmlElement root, String node_name, String value_name, String value)
		{
			XmlElement node = (XmlElement) root[node_name];
            if (node == null)
            {
                node = root.OwnerDocument.CreateElement(node_name);
                root.AppendChild(node);
            }

			node.SetAttribute(value_name, value);
		}

        public static int GetStringId(String str)
        {
            byte[] hash = MD5.Create().ComputeHash(Encoding.UTF8.GetBytes(str.ToLower()));
            int v1 = BitConverter.ToInt32(hash, 0);
            int v2 = BitConverter.ToInt32(hash, 4);
            int v3 = BitConverter.ToInt32(hash, 8);
            int v4 = BitConverter.ToInt32(hash, 12);
            return v1 ^ v2 ^ v3 ^ v4;
        }

		private TextUtil()
        { }
    }
}
