using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace StarifficEditor
{
    public partial class GameForm : Form
    {
        private Level m_level;
        private Meshes m_meshes;
        private String m_export_path;

        public GameForm(Level level, Meshes meshes)
        {
            InitializeComponent();

            m_level = level;
            m_meshes = meshes;
            gameControl.owner_form = this;
        }

        public GameForm(Level level, Meshes meshes, int w, int h, String opt_export_path)
            : this(level, meshes)
        {
            SetClientSizeCore(w, h);
            m_export_path = opt_export_path;
        }

        private void GameForm_Load(object sender, EventArgs e)
        {
            byte[] level_data = m_level.Export();
            sbyte[] slevel_data = Array.ConvertAll(level_data, new Converter<byte, sbyte>(ByteConverter));

            byte[] mesh_data = m_meshes.Export();
            sbyte[] smesh_data = Array.ConvertAll(mesh_data, new Converter<byte, sbyte>(ByteConverter));

            if (m_export_path != null)
                gameControl.StartGame(m_export_path);
            else
                gameControl.StartGame(slevel_data, smesh_data);
        }

        private static sbyte ByteConverter(byte v)
        {
            return (sbyte)v;
        }

        private void GameForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            gameControl.StopGame();
        }
    }
}