using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml;

namespace StarifficEditor
{
    public class ExportOptions
    {
        public List<String> levels;

        private String m_level_path;
        public String LevelPath
        {
            get { return m_level_path; }
        }

        private String ExportFile
        {
            get { return Path.Combine(m_level_path, "export.xml"); }
        }

        public ExportOptions(String level_path)
        {
            levels = new List<string>();
            m_level_path = level_path;
            Clear();
        }

        public void Clear()
        {
            levels.Clear();
        }

        public bool Load()
        {
            try
            {
                Clear();

                // Load the XML
                XmlDocument doc = new XmlDocument();
                doc.Load(ExportFile);

                // Load the levels
                foreach (XmlElement level_elem in doc.DocumentElement["levels"].SelectNodes("level"))
                {
                    String level = level_elem.GetAttribute("name");
                    if (level != null)
                        levels.Add(level);
                }

                return true;
            }
            catch (Exception)
            {
                Clear();
                return false;
            }
        }

        public bool Save()
        {
            try
            {
                XmlDocument doc = new XmlDocument();

                // Create document root
                doc.AppendChild(doc.CreateXmlDeclaration("1.0", null, null));
                XmlElement root = doc.CreateElement("export");
                doc.AppendChild(root);

                // Save the levels
                if (true)
                {
                    XmlElement levels_root = doc.CreateElement("levels");
                    root.AppendChild(levels_root);

                    foreach (String level in levels)
                    {
                        XmlElement level_elem = doc.CreateElement("level");
                        level_elem.SetAttribute("name", level);
                        levels_root.AppendChild(level_elem);
                    }
                }

                // Save
                doc.Save(ExportFile);
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }
    }
}
