import javax.microedition.lcdui.*;

/** 
 * Screen class.
 */
public abstract class Screen
{
    public Screen()
    {
    }
    
    /**
     * Updates the screen for a fixed amount of time.
     * 
     * @param fp_secs The time to update, in fixed point seconds.
     */
    public abstract Screen updateFrame( int fp_secs );
    
    /**
     * Renders the current state to the given graphics.
     * 
     * @param g The destination graphics.
     * @param w The screen width.
     * @param h The screen height.
     */
    public abstract void render( Graphics g, int w, int h );

    public void keyPressed( int key, int game_key )
    {
    }
}
