package javax.microedition.media;

import java.applet.*;

public class Player
{
    private AudioClip m_clip;
    private boolean m_looping;
    
    public Player(AudioClip clip)
    {
        m_clip = clip;
    }

    public void stop()
    {
        try
        {
            m_clip.stop();
        }
        catch ( Throwable t )
        {
            System.out.println( "Error stopping music:" );
            t.printStackTrace();
        }
    }

    public void start()
    {
        try
        {
            m_clip.play();
            if ( m_looping )
                m_clip.loop();
        }
        catch ( Throwable t )
        {
            System.out.println( "Error starting music:" );
            t.printStackTrace();
        }
    }

    public void setLoopCount(int cnt)
    {
        if ( cnt != 1 )
            m_looping = true;
    }
    
    public void setMediaTime(long time)
    {
    }

    public void realize()
    {
    }

    public void prefetch()
    {
    }
}
