////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;



/**
 * Fixed point arithmetic. 
 */
public final class FP
{
    public static final int SHIFT = 16;
    
    public static final int ZERO = 0;
    public static final int ONE = 0x10000;
    public static final int PI = 0x3243F;
    public static final int PI2 = PI * 2;
    public static final int PI_HALF = 0x1921F;

    /**
     * Conversion from an integer to a fixed point.
     */
    public static final int toFP( int val )
    {
        return val << SHIFT;
    }
    
    /**
     * Conversion from a float to a fixed point.
     */
    public static final int toFP( float val )
    {
        return (int) (val * 65536.f);
    }
    
    /**
     * Conversion to integer.
     */
    public static final int toInt( int fp )
    {
        return fp >> SHIFT;
    }

    /**
     * Ceiling function, converts to integer.
     */
    public static final int toCeilInt( int fp )
    {
        return ((fp+0xffff) >> SHIFT);
    }
    
    /**
     * Conversion to float.
     */
    public static final float toFloat( int fp )
    {
        return (float)fp / 65536.f; 
    }
    
    /**
     * Conversion to a string.
     */
    public static final String toString( int fp )
    {
        return String.valueOf( toFloat( fp ) );
    }
    
    /**
     * Fixed point multiplication.
     */
    public static final int mul( int a, int b )
    {
        return (int) (((long)a * (long)b)>>SHIFT);
    }
    
    /**
     * Fixed point division.
     */
    public static final int div( int a, int b )
    {
        return (int) ((((long)a)<<SHIFT) / (long)b);
    }
    
    /**
     * Returns the cosine of the given angle (in radians).
     * 
     * @param ang The angle in radians.
     * @return The cosine value.
     */
    public static final int cos( int ang )
    {
        return sin( ang + PI_HALF );
    }
    
    /**
     * Returns the sine of the given angle (in radians).
     * 
     * @param ang The angle in radians.
     * @return The cosine value.
     */
    public static final int sin( int ang )
    {
        // Wrap the sin to 0<=ang<2*pi
        while ( ang < 0 )
            ang += PI2;
        while ( ang >= PI2 )
            ang -= PI2;
        
        // Make to two opposite half circles
        boolean neg = (ang >= PI);
        if (neg)
            ang -= PI;
        
        // Get the value
        int val;
        if ( ang < PI_HALF )
            val = SIN_TABLE[FP.div((SIN_TABLE.length-1)*ang, PI_HALF) >> 16];
        else
            val = ONE - SIN_TABLE[FP.div((SIN_TABLE.length-1)*(ang-PI_HALF), PI_HALF) >> 16];
        
        return neg ? -val : val;
    }
    
	/**
	 * Square root approximation.
	 * http://www.cstone.net/~kyoung/fix1FAQ.html
	 * 
	 * @param x		Input value.
	 * @return		Square root of x.
	 */
	public static final int sqrt(int x)
	{
	    // Adapted from http://www.worldserver.com/turk/computergraphics/FixedSqrt.pdf
	    // The algo works with 2:30 fp, so we first divide the 16:16 by multiple of 4:s so that it fits.
	    // Afterwards we move the 2:30 fp -> 16:16 fp and multiply the answer by 2:s so that the answer matches (sqrt(4)=2).
	    
		if ( x <= 0 )
			return 0;

		int x_shift = 0;
		while ( (x>>x_shift) > 0x1ffff )
			x_shift += 2;
		x <<= (30-16 - x_shift);
		x_shift 
        >>= 1;

		int root = 0;
		int remHi = 0;
		int remLo = x;
		int count = 30;

		do
		{
			remHi = (remHi<<2) | ((remLo>>30)&0x3);
			remLo <<= 2;
			root <<= 1;
			int testDiv = (root << 1) + 1;
			if ( remHi >= testDiv )
			{
				remHi -= testDiv;
				++root;
			}
		} while ( count-- != 0 );

		return (int) (root >> (30-16-x_shift));
	}    
    
    private FP()
    { }

    private static final int[] SIN_TABLE =
    {
        0x00000000, // sin(0.000000) = 0.000000
        0x00000648, // sin(0.024544) = 0.024541
        0x00000c8f, // sin(0.049087) = 0.049068
        0x000012d5, // sin(0.073631) = 0.073565
        0x00001917, // sin(0.098175) = 0.098017
        0x00001f56, // sin(0.122718) = 0.122411
        0x00002590, // sin(0.147262) = 0.146730
        0x00002bc4, // sin(0.171806) = 0.170962
        0x000031f1, // sin(0.196350) = 0.195090
        0x00003817, // sin(0.220893) = 0.219101
        0x00003e33, // sin(0.245437) = 0.242980
        0x00004447, // sin(0.269981) = 0.266713
        0x00004a50, // sin(0.294524) = 0.290285
        0x0000504d, // sin(0.319068) = 0.313682
        0x0000563e, // sin(0.343612) = 0.336890
        0x00005c22, // sin(0.368155) = 0.359895
        0x000061f7, // sin(0.392699) = 0.382683
        0x000067bd, // sin(0.417243) = 0.405241
        0x00006d74, // sin(0.441786) = 0.427555
        0x00007319, // sin(0.466330) = 0.449611
        0x000078ad, // sin(0.490874) = 0.471397
        0x00007e2e, // sin(0.515418) = 0.492898
        0x0000839c, // sin(0.539961) = 0.514103
        0x000088f5, // sin(0.564505) = 0.534998
        0x00008e39, // sin(0.589049) = 0.555570
        0x00009368, // sin(0.613592) = 0.575808
        0x0000987f, // sin(0.638136) = 0.595699
        0x00009d7f, // sin(0.662680) = 0.615232
        0x0000a267, // sin(0.687223) = 0.634393
        0x0000a736, // sin(0.711767) = 0.653173
        0x0000abeb, // sin(0.736311) = 0.671559
        0x0000b085, // sin(0.760854) = 0.689541
        0x0000b504, // sin(0.785398) = 0.707107
        0x0000b968, // sin(0.809942) = 0.724247
        0x0000bdae, // sin(0.834486) = 0.740951
        0x0000c1d8, // sin(0.859029) = 0.757209
        0x0000c5e4, // sin(0.883573) = 0.773010
        0x0000c9d1, // sin(0.908117) = 0.788346
        0x0000cd9f, // sin(0.932660) = 0.803208
        0x0000d14d, // sin(0.957204) = 0.817585
        0x0000d4db, // sin(0.981748) = 0.831470
        0x0000d848, // sin(1.006291) = 0.844854
        0x0000db94, // sin(1.030835) = 0.857729
        0x0000debe, // sin(1.055379) = 0.870087
        0x0000e1c5, // sin(1.079922) = 0.881921
        0x0000e4aa, // sin(1.104466) = 0.893224
        0x0000e76b, // sin(1.129010) = 0.903989
        0x0000ea09, // sin(1.153554) = 0.914210
        0x0000ec83, // sin(1.178097) = 0.923880
        0x0000eed8, // sin(1.202641) = 0.932993
        0x0000f109, // sin(1.227185) = 0.941544
        0x0000f314, // sin(1.251728) = 0.949528
        0x0000f4fa, // sin(1.276272) = 0.956940
        0x0000f6ba, // sin(1.300816) = 0.963776
        0x0000f853, // sin(1.325359) = 0.970031
        0x0000f9c7, // sin(1.349903) = 0.975702
        0x0000fb14, // sin(1.374447) = 0.980785
        0x0000fc3b, // sin(1.398991) = 0.985278
        0x0000fd3a, // sin(1.423534) = 0.989177
        0x0000fe13, // sin(1.448078) = 0.992480
        0x0000fec4, // sin(1.472622) = 0.995185
        0x0000ff4e, // sin(1.497165) = 0.997290
        0x0000ffb1, // sin(1.521709) = 0.998795
        0x0000ffec, // sin(1.546253) = 0.999699
    };
}
