/*
 * Decompiled with CFR 0.152.
 */
package StarifficEditorGame;

import StarifficEditorGame.Collidable;
import StarifficEditorGame.FP;
import StarifficEditorGame.LevelObject;
import StarifficEditorGame.Res;
import StarifficEditorGame.Vec2;
import StarifficEditorGame.Verlet;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Star
extends LevelObject {
    public boolean is_at_home;
    public boolean is_dead;
    private Verlet m_verlet_center = new Verlet();
    private Verlet m_verlet_top = new Verlet();
    private Verlet m_verlet_topleft = new Verlet();
    private Verlet m_verlet_topright = new Verlet();
    private Verlet m_verlet_bottomleft = new Verlet();
    private Verlet m_verlet_bottomright = new Verlet();
    private Verlet[] m_verlets = new Verlet[]{this.m_verlet_top, this.m_verlet_topright, this.m_verlet_bottomright, this.m_verlet_bottomleft, this.m_verlet_topleft, this.m_verlet_center};
    private int m_dist_to_center;
    private int m_dist_to_extent;
    private int m_dist_split;
    private int[] m_intpos_center = new int[2];
    private int[] m_intpos_top = new int[2];
    private int[] m_intpos_topleft = new int[2];
    private int[] m_intpos_topright = new int[2];
    private int[] m_intpos_bottomleft = new int[2];
    private int[] m_intpos_bottomright = new int[2];
    private int[] m_intpos_middle1 = new int[2];
    private int[] m_intpos_middle2 = new int[2];
    private int[] m_intpos_middle3 = new int[2];
    private int[] m_intpos_middle4 = new int[2];
    private int[] m_intpos_middle5 = new int[2];
    private Vector m_hit_objects = new Vector();
    private int m_particle_shine_delay;
    private int m_draw_scale = 65536;
    private static final int[] g_tangent_horiz;
    private static final int[] g_tangent_vert;
    private static final int g_friction_amount;
    private static final int[] g_temp_vec;
    private static final int[] g_temp_vec2;
    private static final int g_star_size;
    private static final int g_star_center_ball_size;
    private static final int g_star_mid_scale;
    private static final int g_star_mouth_size;
    private static final int g_impulse_force;
    private static final int g_rotation_force;
    private static final int g_particle_add_time;
    private static final int g_end_shrink_mul;
    private static final int[][] g_star_dirs;

    static {
        int[] nArray = new int[2];
        nArray[0] = 65536;
        g_tangent_horiz = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 65536;
        g_tangent_vert = nArray2;
        g_friction_amount = FP.toFP(0.95f);
        g_temp_vec = new int[2];
        g_temp_vec2 = new int[2];
        g_star_size = FP.toFP(1);
        g_star_center_ball_size = FP.mul(g_star_size, FP.toFP(0.4f));
        g_star_mid_scale = FP.toFP(0.5f);
        g_star_mouth_size = FP.toFP(0.4f);
        g_impulse_force = FP.toFP(0.35f);
        g_rotation_force = FP.toFP(0.35f);
        g_particle_add_time = FP.toFP(0.1f);
        g_end_shrink_mul = FP.toFP(0.85f);
        int[][] nArrayArray = new int[5][];
        int[] nArray3 = new int[2];
        nArray3[1] = -65536;
        nArrayArray[0] = nArray3;
        nArrayArray[1] = new int[]{62328, -20251};
        nArrayArray[2] = new int[]{38521, 53019};
        nArrayArray[3] = new int[]{-38521, 53019};
        nArrayArray[4] = new int[]{-62328, -20251};
        g_star_dirs = nArrayArray;
    }

    public Star() {
        this.reset(Vec2.create());
    }

    public int getX() {
        return this.m_verlet_center.pos[0];
    }

    public int getY() {
        return this.m_verlet_center.pos[1];
    }

    public void reset(int[] pos) {
        int[] temp = Vec2.create();
        this.m_verlet_center.resetPos(pos);
        Vec2.addScaled(temp, pos, g_star_dirs[0], g_star_size);
        this.m_verlet_top.resetPos(temp);
        Vec2.addScaled(temp, pos, g_star_dirs[1], g_star_size);
        this.m_verlet_topright.resetPos(temp);
        Vec2.addScaled(temp, pos, g_star_dirs[2], g_star_size);
        this.m_verlet_bottomright.resetPos(temp);
        Vec2.addScaled(temp, pos, g_star_dirs[3], g_star_size);
        this.m_verlet_bottomleft.resetPos(temp);
        Vec2.addScaled(temp, pos, g_star_dirs[4], g_star_size);
        this.m_verlet_topleft.resetPos(temp);
        this.m_dist_to_center = Vec2.dist(this.m_verlets[0].pos, this.m_verlet_center.pos);
        this.m_dist_to_extent = Vec2.dist(this.m_verlets[0].pos, this.m_verlets[1].pos);
        this.m_dist_split = Vec2.dist(this.m_verlets[0].pos, this.m_verlets[2].pos);
    }

    public void completed() {
        if (this.is_at_home || this.is_dead) {
            return;
        }
        this.is_at_home = true;
        Res.audio.playSound(Res.audio.sound_win);
    }

    public void kill() {
        if (this.is_dead || this.is_at_home) {
            return;
        }
        this.is_dead = true;
        int i = 0;
        while (i < 32) {
            int v = Res.random.nextInt(5);
            int t = Res.random.nextInt(65536);
            Vec2.sub(g_temp_vec, this.m_verlets[v].pos, this.m_verlet_center.pos);
            this.m_verlet_center.getVelocity(g_temp_vec2);
            Vec2.scale(g_temp_vec2, FP.toFP(30));
            g_temp_vec2[0] = g_temp_vec2[0] + (-131072 + Res.random.nextInt(262144));
            g_temp_vec2[1] = g_temp_vec2[1] + (-196608 + Res.random.nextInt(262144));
            Vec2.addScaled(g_temp_vec, this.m_verlet_center.pos, g_temp_vec, t);
            this.level.particles.addParticle(g_temp_vec, g_temp_vec2, -3355648, 196608);
            ++i;
        }
        Res.audio.playSound(Res.audio.sound_die);
    }

    public void addImpulse(int idx) {
        Vec2.sub(g_temp_vec, this.m_verlets[idx].pos, this.m_verlet_center.pos);
        Vec2.normalize(g_temp_vec);
        Vec2.scale(g_temp_vec, g_impulse_force);
        this.m_verlets[idx].addVelocity(g_temp_vec);
        this.m_verlet_center.addVelocity(g_temp_vec);
    }

    public void addRotation(int dir) {
        boolean inv_force = false;
        switch (this.level.gravity_dir) {
            case 1: {
                if (dir == 2) {
                    inv_force = true;
                    break;
                }
                if (dir == 0) {
                    inv_force = false;
                    break;
                }
                return;
            }
            case 3: {
                if (dir == 2) {
                    inv_force = false;
                    break;
                }
                if (dir == 0) {
                    inv_force = true;
                    break;
                }
                return;
            }
            case 2: {
                if (dir == 3) {
                    inv_force = true;
                    break;
                }
                if (dir == 1) {
                    inv_force = false;
                    break;
                }
                return;
            }
            case 0: {
                if (dir == 3) {
                    inv_force = false;
                    break;
                }
                if (dir == 1) {
                    inv_force = true;
                    break;
                }
                return;
            }
        }
        int force = g_rotation_force;
        if (inv_force) {
            force = -force;
        }
        int i = 0;
        while (i < 5) {
            Vec2.sub(g_temp_vec, this.m_verlets[i].pos, this.m_verlet_center.pos);
            Vec2.normalize(g_temp_vec);
            Vec2.scale(g_temp_vec, force);
            Vec2.makeNormal(g_temp_vec);
            this.m_verlets[i].addVelocity(g_temp_vec);
            ++i;
        }
    }

    public void bump(Verlet v, int nx, int ny, int power) {
        int power_sec = power * 8 / 10;
        int i = 0;
        while (i < this.m_verlets.length) {
            Verlet ver;
            ver.bump(nx, ny, (ver = this.m_verlets[i]) == v ? power : power_sec);
            ++i;
        }
        Res.audio.playSound(Res.audio.sound_bump);
    }

    public void update(int time_secs) {
        if (this.is_at_home) {
            this.m_draw_scale = FP.mul(this.m_draw_scale, g_end_shrink_mul);
            if (this.m_draw_scale < 1000) {
                this.m_draw_scale = 0;
            }
            this.m_particle_shine_delay -= time_secs;
            while (this.m_particle_shine_delay < 0) {
                int i = 0;
                while (i < 3) {
                    Star.g_temp_vec[0] = -327680 + Res.random.nextInt(655360);
                    Star.g_temp_vec[1] = -327680 + Res.random.nextInt(655360);
                    this.level.particles.addParticle(this.m_verlet_center.pos, g_temp_vec, -224, 65536);
                    ++i;
                }
                this.m_particle_shine_delay += g_particle_add_time;
            }
            return;
        }
        int time_2 = FP.mul(time_secs, time_secs);
        int i = 0;
        while (i < this.m_verlets.length) {
            this.m_verlets[i].integrate(time_2, this.level.gravity_vec);
            ++i;
        }
        i = 0;
        while (i < 5) {
            int idx1 = (i + 2) % 5;
            this.lineConstraint(this.m_verlets[i], this.m_verlets[idx1], this.m_dist_split);
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.lineConstraint(this.m_verlets[i], this.m_verlet_center, this.m_dist_to_center);
            ++i;
        }
        i = 0;
        while (i < 5) {
            int i2 = (i + 1) % 5;
            this.lineConstraint(this.m_verlets[i], this.m_verlets[i2], this.m_dist_to_extent);
            ++i;
        }
        this.updateBoundingBox();
        this.level.regionFetch(this.bounding_box, this.m_hit_objects);
        i = 0;
        while (i < this.m_verlets.length) {
            this.borderConstraint(this.m_verlets[i]);
            ++i;
        }
        this.borderConstraint(this.m_verlet_center);
        this.updateBoundingBox();
        if (!this.is_at_home && !this.is_dead) {
            this.m_particle_shine_delay -= time_secs;
            while (this.m_particle_shine_delay < 0) {
                this.m_particle_shine_delay += g_particle_add_time;
            }
        }
    }

    private void lineConstraint(Verlet v1, Verlet v2, int req_dist) {
        Vec2.sub(g_temp_vec, v2.pos, v1.pos);
        int delta_len = Vec2.normalize(g_temp_vec);
        if (delta_len <= 0) {
            return;
        }
        delta_len = req_dist - delta_len >> 1;
        int j = 0;
        while (j < 2) {
            int n = j;
            v1.pos[n] = v1.pos[n] - FP.mul(g_temp_vec[j], delta_len);
            int n2 = j;
            v2.pos[n2] = v2.pos[n2] + FP.mul(g_temp_vec[j], delta_len);
            ++j;
        }
    }

    private void borderConstraint(Verlet v) {
        int amt = this.m_hit_objects.size();
        int i = 0;
        while (i < amt) {
            LevelObject obj = (LevelObject)this.m_hit_objects.elementAt(i);
            if (obj instanceof Collidable) {
                ((Collidable)((Object)obj)).resolveCollision(v);
            }
            ++i;
        }
    }

    private void updateBoundingBox() {
        this.bounding_box.x1 = this.bounding_box.x2 = this.m_verlet_center.pos[0];
        this.bounding_box.y1 = this.bounding_box.y2 = this.m_verlet_center.pos[1];
        int size2 = g_star_size;
        this.bounding_box.x1 -= size2;
        this.bounding_box.y1 -= size2;
        this.bounding_box.x2 += size2;
        this.bounding_box.y2 += size2;
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        if (this.is_dead) {
            return;
        }
        Vec2.getScaledInt(this.m_intpos_center, this.m_verlet_center.pos, top_x, top_y, scale_x, scale_y);
        Vec2.getScaledInt(this.m_intpos_top, this.m_verlet_top.pos, top_x, top_y, scale_x, scale_y);
        Vec2.getScaledInt(this.m_intpos_topleft, this.m_verlet_topleft.pos, top_x, top_y, scale_x, scale_y);
        Vec2.getScaledInt(this.m_intpos_topright, this.m_verlet_topright.pos, top_x, top_y, scale_x, scale_y);
        Vec2.getScaledInt(this.m_intpos_bottomleft, this.m_verlet_bottomleft.pos, top_x, top_y, scale_x, scale_y);
        Vec2.getScaledInt(this.m_intpos_bottomright, this.m_verlet_bottomright.pos, top_x, top_y, scale_x, scale_y);
        this.getMidPoint(this.m_intpos_middle1, this.m_verlet_topleft, this.m_verlet_top, g_star_mid_scale, top_x, top_y, scale_x, scale_y);
        this.getMidPoint(this.m_intpos_middle2, this.m_verlet_top, this.m_verlet_topright, g_star_mid_scale, top_x, top_y, scale_x, scale_y);
        this.getMidPoint(this.m_intpos_middle3, this.m_verlet_topright, this.m_verlet_bottomright, g_star_mid_scale, top_x, top_y, scale_x, scale_y);
        this.getMidPoint(this.m_intpos_middle4, this.m_verlet_bottomright, this.m_verlet_bottomleft, g_star_mid_scale, top_x, top_y, scale_x, scale_y);
        this.getMidPoint(this.m_intpos_middle5, this.m_verlet_bottomleft, this.m_verlet_topleft, g_star_mid_scale, top_x, top_y, scale_x, scale_y);
        if (this.m_draw_scale != 65536) {
            if (this.m_draw_scale <= 0) {
                return;
            }
            this.scaleIntPoint(this.m_intpos_top, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_topleft, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_topright, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_bottomleft, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_bottomright, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_middle1, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_middle2, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_middle3, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_middle4, this.m_intpos_center, this.m_draw_scale);
            this.scaleIntPoint(this.m_intpos_middle5, this.m_intpos_center, this.m_draw_scale);
        }
        g.setColor(-256);
        g.fillTriangle(this.m_intpos_middle5[0], this.m_intpos_middle5[1], this.m_intpos_middle1[0], this.m_intpos_middle1[1], this.m_intpos_topleft[0], this.m_intpos_topleft[1]);
        g.fillTriangle(this.m_intpos_middle1[0], this.m_intpos_middle1[1], this.m_intpos_middle2[0], this.m_intpos_middle2[1], this.m_intpos_top[0], this.m_intpos_top[1]);
        g.fillTriangle(this.m_intpos_middle2[0], this.m_intpos_middle2[1], this.m_intpos_middle3[0], this.m_intpos_middle3[1], this.m_intpos_topright[0], this.m_intpos_topright[1]);
        g.fillTriangle(this.m_intpos_middle3[0], this.m_intpos_middle3[1], this.m_intpos_middle4[0], this.m_intpos_middle4[1], this.m_intpos_bottomright[0], this.m_intpos_bottomright[1]);
        g.fillTriangle(this.m_intpos_middle4[0], this.m_intpos_middle4[1], this.m_intpos_middle5[0], this.m_intpos_middle5[1], this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1]);
        g.setColor(-256);
        g.fillTriangle(this.m_intpos_middle1[0], this.m_intpos_middle1[1], this.m_intpos_middle2[0], this.m_intpos_middle2[1], this.m_intpos_middle3[0], this.m_intpos_middle3[1]);
        g.fillTriangle(this.m_intpos_middle1[0], this.m_intpos_middle1[1], this.m_intpos_middle3[0], this.m_intpos_middle3[1], this.m_intpos_middle4[0], this.m_intpos_middle4[1]);
        g.fillTriangle(this.m_intpos_middle1[0], this.m_intpos_middle1[1], this.m_intpos_middle4[0], this.m_intpos_middle4[1], this.m_intpos_middle5[0], this.m_intpos_middle5[1]);
        g.setColor(-13421824);
        g.drawLine(this.m_intpos_top[0], this.m_intpos_top[1], this.m_intpos_middle1[0], this.m_intpos_middle1[1]);
        g.drawLine(this.m_intpos_top[0], this.m_intpos_top[1], this.m_intpos_middle2[0], this.m_intpos_middle2[1]);
        g.drawLine(this.m_intpos_topright[0], this.m_intpos_topright[1], this.m_intpos_middle2[0], this.m_intpos_middle2[1]);
        g.drawLine(this.m_intpos_topright[0], this.m_intpos_topright[1], this.m_intpos_middle3[0], this.m_intpos_middle3[1]);
        g.drawLine(this.m_intpos_bottomright[0], this.m_intpos_bottomright[1], this.m_intpos_middle3[0], this.m_intpos_middle3[1]);
        g.drawLine(this.m_intpos_bottomright[0], this.m_intpos_bottomright[1], this.m_intpos_middle4[0], this.m_intpos_middle4[1]);
        g.drawLine(this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1], this.m_intpos_middle4[0], this.m_intpos_middle4[1]);
        g.drawLine(this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1], this.m_intpos_middle5[0], this.m_intpos_middle5[1]);
        g.drawLine(this.m_intpos_topleft[0], this.m_intpos_topleft[1], this.m_intpos_middle5[0], this.m_intpos_middle5[1]);
        g.drawLine(this.m_intpos_topleft[0], this.m_intpos_topleft[1], this.m_intpos_middle1[0], this.m_intpos_middle1[1]);
        int mouth_size = FP.mul(g_star_mouth_size, scale_x);
        if (this.m_draw_scale != 65536) {
            mouth_size = FP.mul(mouth_size, this.m_draw_scale);
        }
        mouth_size = FP.toInt(mouth_size);
        int mouth_size2 = mouth_size / 2;
        int mouth_size4 = mouth_size / 4;
        if (mouth_size <= 0) {
            mouth_size = 1;
        }
        if (mouth_size2 <= 0) {
            mouth_size2 = 1;
        }
        if (mouth_size4 <= 0) {
            mouth_size4 = 1;
        }
        g.setColor(-1);
        int x = (this.m_intpos_center[0] + this.m_intpos_middle1[0] * 2) / 3;
        int y = (this.m_intpos_center[1] + this.m_intpos_middle1[1] * 2) / 3;
        g.fillArc(x - mouth_size2, y - mouth_size2, mouth_size, mouth_size, 0, 360);
        g.setColor(-16777216);
        g.fillArc(x - mouth_size4, y - mouth_size4, mouth_size2, mouth_size2, 0, 360);
        g.setColor(-1);
        x = (this.m_intpos_center[0] + this.m_intpos_middle2[0] * 2) / 3;
        y = (this.m_intpos_center[1] + this.m_intpos_middle2[1] * 2) / 3;
        g.fillArc(x - mouth_size2, y - mouth_size2, mouth_size, mouth_size, 0, 360);
        g.setColor(-16777216);
        g.fillArc(x - mouth_size4, y - mouth_size4, mouth_size2, mouth_size2, 0, 360);
        g.setColor(-14540288);
        x = (this.m_intpos_center[0] * 6 + this.m_intpos_middle1[0] + this.m_intpos_middle2[0]) / 8;
        y = (this.m_intpos_center[1] * 6 + this.m_intpos_middle1[1] + this.m_intpos_middle2[1]) / 8;
        g.fillArc(x - mouth_size4, y - mouth_size4, mouth_size2, mouth_size2, 0, 360);
    }

    private void getMidPoint(int[] dest, Verlet v1, Verlet v2, int scale, int top_x, int top_y, int scale_x, int scale_y) {
        int[] center = this.m_verlet_center.pos;
        dest[0] = center[0] + FP.mul(v1.pos[0] - center[0] + (v2.pos[0] - center[0]), scale >>= 1);
        dest[1] = center[1] + FP.mul(v1.pos[1] - center[1] + (v2.pos[1] - center[1]), scale);
        dest[0] = FP.toInt(FP.mul(dest[0] - top_x, scale_x));
        dest[1] = FP.toInt(FP.mul(dest[1] - top_y, scale_y));
    }

    private void scaleIntPoint(int[] pt, int[] center, int scale) {
        pt[0] = center[0] + FP.toInt(scale * (pt[0] - center[0]));
        pt[1] = center[1] + FP.toInt(scale * (pt[1] - center[1]));
    }

    private void renderDebug(Graphics g) {
        g.setColor(-14618768);
        g.drawLine(this.m_intpos_top[0], this.m_intpos_top[1], this.m_intpos_center[0], this.m_intpos_center[1]);
        g.drawLine(this.m_intpos_topleft[0], this.m_intpos_topleft[1], this.m_intpos_center[0], this.m_intpos_center[1]);
        g.drawLine(this.m_intpos_topright[0], this.m_intpos_topright[1], this.m_intpos_center[0], this.m_intpos_center[1]);
        g.drawLine(this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1], this.m_intpos_center[0], this.m_intpos_center[1]);
        g.drawLine(this.m_intpos_bottomright[0], this.m_intpos_bottomright[1], this.m_intpos_center[0], this.m_intpos_center[1]);
        g.setColor(-13598465);
        g.drawLine(this.m_intpos_top[0], this.m_intpos_top[1], this.m_intpos_topright[0], this.m_intpos_topright[1]);
        g.drawLine(this.m_intpos_topright[0], this.m_intpos_topright[1], this.m_intpos_bottomright[0], this.m_intpos_bottomright[1]);
        g.drawLine(this.m_intpos_bottomright[0], this.m_intpos_bottomright[1], this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1]);
        g.drawLine(this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1], this.m_intpos_topleft[0], this.m_intpos_topleft[1]);
        g.drawLine(this.m_intpos_topleft[0], this.m_intpos_topleft[1], this.m_intpos_top[0], this.m_intpos_top[1]);
        g.setColor(-13598465);
        g.drawLine(this.m_intpos_top[0], this.m_intpos_top[1], this.m_intpos_bottomright[0], this.m_intpos_bottomright[1]);
        g.drawLine(this.m_intpos_topright[0], this.m_intpos_topright[1], this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1]);
        g.drawLine(this.m_intpos_bottomright[0], this.m_intpos_bottomright[1], this.m_intpos_topleft[0], this.m_intpos_topleft[1]);
        g.drawLine(this.m_intpos_bottomleft[0], this.m_intpos_bottomleft[1], this.m_intpos_top[0], this.m_intpos_top[1]);
        g.drawLine(this.m_intpos_topleft[0], this.m_intpos_topleft[1], this.m_intpos_topright[0], this.m_intpos_topright[1]);
        g.setColor(-65536);
        g.fillRect(this.m_intpos_center[0] - 1, this.m_intpos_center[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_top[0] - 1, this.m_intpos_top[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_topleft[0] - 1, this.m_intpos_topleft[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_topright[0] - 1, this.m_intpos_topright[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_bottomleft[0] - 1, this.m_intpos_bottomleft[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_bottomright[0] - 1, this.m_intpos_bottomright[1] - 1, 3, 3);
        g.setColor(-7405568);
        g.fillRect(this.m_intpos_middle1[0] - 1, this.m_intpos_middle1[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_middle2[0] - 1, this.m_intpos_middle2[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_middle3[0] - 1, this.m_intpos_middle3[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_middle4[0] - 1, this.m_intpos_middle4[1] - 1, 3, 3);
        g.fillRect(this.m_intpos_middle5[0] - 1, this.m_intpos_middle5[1] - 1, 3, 3);
    }

    public void load(DataInputStream in) throws IOException {
        int pos_x = in.readInt();
        int pos_y = in.readInt();
        this.reset(Vec2.create(pos_x, pos_y));
    }
}

