/*
 * Decompiled with CFR 0.152.
 */
package StarifficEditorGame;

import StarifficEditorGame.Res;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class Audio {
    public Player music_menu;
    public Player music_game;
    public Player music_game2;
    public Player sound_die;
    public Player sound_win;
    public Player sound_bump;
    public Player sound_grav;
    public Player sound_item;
    private Player m_cur_music;

    public void init() {
        this.music_menu = this.loadSound("/m.mid", "audio/midi");
        this.music_game = this.loadSound("/g.mid", "audio/midi");
        this.music_game2 = this.loadSound("/g2.mid", "audio/midi");
        if (Res.pc_mode) {
            this.sound_die = this.loadSound("/die.au", "audio/basic");
            this.sound_win = this.loadSound("/win.au", "audio/basic");
            this.sound_bump = this.loadSound("/bump.au", "audio/basic");
            this.sound_grav = this.loadSound("/grav.au", "audio/basic");
            this.sound_item = this.loadSound("/win.au", "audio/basic");
        }
    }

    public void playSound(Player plr) {
        if (plr == null) {
            return;
        }
        try {
            plr.stop();
            plr.setMediaTime(0L);
            plr.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void playMusic(Player plr) {
        if (this.m_cur_music == plr) {
            return;
        }
        if (this.m_cur_music != null) {
            try {
                this.m_cur_music.stop();
            }
            catch (Throwable t) {
                System.out.println("Error stopping music:");
                t.printStackTrace();
            }
            this.m_cur_music = null;
        }
        this.m_cur_music = plr;
        if (this.m_cur_music != null) {
            try {
                this.m_cur_music.setMediaTime(0L);
                this.m_cur_music.setLoopCount(-1);
                this.m_cur_music.start();
            }
            catch (Throwable t) {
                System.out.println("Error starting music:");
                t.printStackTrace();
            }
        }
    }

    private Player loadSound(String name, String mime_type) {
        try {
            Player ret = null;
            if (Res.pc_mode) {
                ret = Manager.createPlayer(name);
                if (ret == null) {
                    return null;
                }
                ret.realize();
                ret.prefetch();
            } else {
                InputStream in = Res.getResourceAsStream(name);
                if (in == null) {
                    return null;
                }
                ret = Manager.createPlayer(in, mime_type);
                if (ret == null) {
                    return null;
                }
                ret.realize();
                ret.prefetch();
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return ret;
        }
        catch (Throwable t) {
            System.out.println("Error loading music:");
            t.printStackTrace();
            return null;
        }
    }
}

