/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class WallRectangle
extends LevelObject
implements Collidable {
    public int mode;
    public int bump_power;
    public int color;
    public int[] draw_vtx;
    public boolean is_rotated;
    public int[] center;
    public int[] axis_x;
    public int[] axis_y;
    public int[] axis_size;
    private int m_bumper;
    private static final int g_friction_amount = FP.toFP(1.0f);
    private static final int g_bumper_min = FP.toFP(0.1f);
    private static final int g_bumper_max = FP.toFP(0.4f);
    private static final int g_bumper_speed = FP.toFP(2.0f);
    private static int[] g_temp_vec = new int[2];
    private static int[] g_temp_vec2 = new int[2];

    public void update(int time_secs) {
        if (this.mode == 2) {
            this.m_bumper -= FP.mul(g_bumper_speed, time_secs);
            if (this.m_bumper < g_bumper_min) {
                this.m_bumper = g_bumper_min;
            }
        }
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        int x1 = FP.toInt(FP.mul(this.draw_vtx[0] - top_x, scale_x));
        int y1 = FP.toInt(FP.mul(this.draw_vtx[1] - top_y, scale_y));
        int x3 = FP.toInt(FP.mul(this.draw_vtx[4] - top_x, scale_x));
        int y3 = FP.toInt(FP.mul(this.draw_vtx[5] - top_y, scale_y));
        g.setColor(this.color);
        int x2 = FP.toInt(FP.mul(this.draw_vtx[2] - top_x, scale_x));
        int y2 = FP.toInt(FP.mul(this.draw_vtx[3] - top_y, scale_y));
        int x4 = FP.toInt(FP.mul(this.draw_vtx[6] - top_x, scale_x));
        int y4 = FP.toInt(FP.mul(this.draw_vtx[7] - top_y, scale_y));
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
        g.fillTriangle(x1, y1, x3, y3, x4, y4);
        if (this.mode == 2) {
            int e1 = this.axis_size[0] + this.m_bumper;
            int e2 = this.axis_size[1] + this.m_bumper;
            int cx = this.center[0];
            int cy = this.center[1];
            int ax_x = FP.mul(this.axis_x[0], e1);
            int ax_y = FP.mul(this.axis_x[1], e1);
            int ay_x = FP.mul(this.axis_y[0], e2);
            int ay_y = FP.mul(this.axis_y[1], e2);
            x1 = FP.toInt(FP.mul(cx + ax_x + ay_x - top_x, scale_x));
            y1 = FP.toInt(FP.mul(cy + ax_y + ay_y - top_y, scale_y));
            x2 = FP.toInt(FP.mul(cx - ax_x + ay_x - top_x, scale_x));
            y2 = FP.toInt(FP.mul(cy - ax_y + ay_y - top_y, scale_y));
            x3 = FP.toInt(FP.mul(cx - ax_x - ay_x - top_x, scale_x));
            y3 = FP.toInt(FP.mul(cy - ax_y - ay_y - top_y, scale_y));
            x4 = FP.toInt(FP.mul(cx + ax_x - ay_x - top_x, scale_x));
            y4 = FP.toInt(FP.mul(cy + ax_y - ay_y - top_y, scale_y));
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x2, y2, x3, y3);
            g.drawLine(x3, y3, x4, y4);
            g.drawLine(x4, y4, x1, y1);
        }
    }

    public void load(DataInputStream in) throws IOException {
        int cx = in.readInt();
        int cy = in.readInt();
        this.center = Vec2.create(cx, cy);
        this.mode = in.readByte();
        this.bump_power = in.readInt();
        this.color = in.readInt();
        this.is_rotated = in.readBoolean();
        this.draw_vtx = new int[8];
        int i = 0;
        while (i < this.draw_vtx.length) {
            this.draw_vtx[i] = in.readInt();
            ++i;
        }
        int axx = in.readInt();
        int axy = in.readInt();
        this.axis_x = Vec2.create(axx, axy);
        int ayx = in.readInt();
        int ayy = in.readInt();
        this.axis_y = Vec2.create(ayx, ayy);
        int sx = in.readInt();
        int sy = in.readInt();
        this.axis_size = Vec2.create(sx, sy);
    }

    public void resolveCollision(Verlet v) {
        int[] tangent;
        int[] normal;
        boolean inv_normal;
        if (this.mode == 1) {
            return;
        }
        if (!this.bounding_box.contains(v.pos[0], v.pos[1])) {
            return;
        }
        Vec2.sub(g_temp_vec, v.pos, this.center);
        int distx = 0;
        int disty = 0;
        int i = 0;
        while (i < 2) {
            int size;
            int[] axis = i == 0 ? this.axis_x : this.axis_y;
            int dist = Vec2.dot(g_temp_vec, axis);
            if (dist > (size = this.axis_size[i]) || dist < -size) {
                return;
            }
            if (i == 0) {
                distx = dist;
            } else {
                disty = dist;
            }
            ++i;
        }
        if (this.axis_size[0] - Math.abs(distx) < this.axis_size[1] - Math.abs(disty)) {
            inv_normal = distx < 0;
            distx = inv_normal ? -this.axis_size[0] : this.axis_size[0];
            normal = this.axis_x;
            tangent = this.axis_y;
        } else {
            inv_normal = disty < 0;
            disty = inv_normal ? -this.axis_size[1] : this.axis_size[1];
            normal = this.axis_y;
            tangent = this.axis_x;
        }
        if (this.mode == 2) {
            int mul = inv_normal ? -1 : 1;
            this.level.star.bump(v, mul * normal[0], mul * normal[1], this.bump_power);
            this.m_bumper = g_bumper_max;
        }
        if (this.mode == 3) {
            this.level.star.kill();
            return;
        }
        Vec2.addScaled(g_temp_vec, this.center, this.axis_x, distx);
        Vec2.addScaled(v.pos, g_temp_vec, this.axis_y, disty);
        v.applyFriction(tangent, g_friction_amount);
    }
}

