/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Mesh {
    public int id;
    public String name;
    public int[] point_data;
    public int[] point_temp;
    public int[] face_data;

    public BoundingBox getBounds() {
        BoundingBox bbox = new BoundingBox();
        int pts = this.point_data.length / 2;
        int idx = 0;
        while (pts-- > 0) {
            int x = this.point_data[idx++];
            int y = this.point_data[idx++];
            if (idx == 2) {
                bbox.x1 = bbox.x2 = x;
                bbox.y1 = bbox.y2 = y;
                continue;
            }
            if (x < bbox.x1) {
                bbox.x1 = x;
            }
            if (x > bbox.x2) {
                bbox.x2 = x;
            }
            if (y < bbox.y1) {
                bbox.y1 = y;
            }
            if (y <= bbox.y2) continue;
            bbox.y2 = y;
        }
        return bbox;
    }

    public int[] render(Graphics g, int mesh_scale, int angle_rad, int move_x, int move_y, int scale_x, int scale_y, int[] cache) {
        int i;
        int idx;
        int pts;
        int i2;
        boolean build_cache = false;
        if (cache == null || cache.length != this.point_data.length + 4) {
            build_cache = true;
        }
        if (!(build_cache || cache[i2 = cache.length - 4] == mesh_scale && cache[i2 + 1] == angle_rad && cache[i2 + 2] == scale_x && cache[i2 + 3] == scale_y)) {
            build_cache = true;
        }
        if (build_cache) {
            if (cache == null || cache.length != this.point_data.length + 4) {
                cache = new int[this.point_data.length + 4];
            }
            int c = FP.cos(angle_rad);
            int s = FP.sin(angle_rad);
            pts = this.point_data.length / 2;
            idx = 0;
            i = 0;
            while (i < pts) {
                int x = FP.mul(this.point_data[idx], mesh_scale);
                int y = FP.mul(this.point_data[idx + 1], mesh_scale);
                cache[idx++] = FP.mul(FP.mul(x, c) - FP.mul(y, s), scale_x);
                cache[idx++] = FP.mul(FP.mul(x, s) + FP.mul(y, c), scale_y);
                ++i;
            }
            cache[idx++] = mesh_scale;
            cache[idx++] = angle_rad;
            cache[idx++] = scale_x;
            cache[idx++] = scale_y;
        }
        int scaled_move_x = FP.mul(move_x, scale_x);
        int scaled_move_y = FP.mul(move_y, scale_y);
        pts = this.point_data.length / 2;
        idx = 0;
        i = 0;
        while (i < pts) {
            this.point_temp[idx] = cache[idx] + scaled_move_x >> 16;
            this.point_temp[++idx] = cache[idx] + scaled_move_y >> 16;
            ++idx;
            ++i;
        }
        int cur_col = g.getColor();
        int faces = this.face_data.length / 4;
        idx = 0;
        int i3 = 0;
        while (i3 < faces) {
            int col = this.face_data[idx++];
            int pt1 = this.face_data[idx++] * 2;
            int pt2 = this.face_data[idx++] * 2;
            int pt3 = this.face_data[idx++] * 2;
            if (col != cur_col) {
                g.setColor(col);
                cur_col = col;
            }
            g.fillTriangle(this.point_temp[pt1], this.point_temp[pt1 + 1], this.point_temp[pt2], this.point_temp[pt2 + 1], this.point_temp[pt3], this.point_temp[pt3 + 1]);
            ++i3;
        }
        return cache;
    }
}

