/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Hiscores {
    private int m_manifest_id;
    private int[] m_scores;

    public Hiscores(int manifest_id, int levels) {
        if (!this.load() || this.m_manifest_id != manifest_id || this.m_scores.length != levels) {
            this.m_manifest_id = manifest_id;
            this.m_scores = new int[levels];
            int i = 0;
            while (i < this.m_scores.length) {
                this.m_scores[i] = FP.toFP(-1);
                ++i;
            }
        }
    }

    public int getScore(int level) {
        if (level < 0 || level >= this.m_scores.length) {
            return FP.toFP(-1);
        }
        return this.m_scores[level];
    }

    public void updateScore(int level, int score) {
        if (level < 0 || level >= this.m_scores.length) {
            return;
        }
        int old = this.m_scores[level];
        if (score < old || old < 0) {
            this.m_scores[level] = score;
            this.save();
        }
    }

    public boolean save() {
        RecordStore rs = null;
        try {
            try {
                rs = RecordStore.openRecordStore((String)"starffic", (boolean)true);
                RecordEnumeration renum = rs.enumerateRecords(null, null, false);
                int id = -1;
                if (renum.hasNextElement()) {
                    id = renum.nextRecordId();
                }
                renum.destroy();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(baos);
                out.writeInt(this.m_manifest_id);
                out.writeShort(this.m_scores.length);
                int i = 0;
                while (i < this.m_scores.length) {
                    out.writeInt(this.m_scores[i]);
                    ++i;
                }
                out.close();
                byte[] rdata = baos.toByteArray();
                if (id == -1) {
                    rs.addRecord(rdata, 0, rdata.length);
                } else {
                    rs.setRecord(id, rdata, 0, rdata.length);
                }
            }
            catch (Throwable t) {
                System.out.println("Hiscore save error:");
                t.printStackTrace();
                try {
                    if (rs != null) {
                        rs.closeRecordStore();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    private boolean load() {
        RecordEnumeration renum;
        RecordStore rs;
        block19: {
            rs = null;
            rs = RecordStore.openRecordStore((String)"starffic", (boolean)false);
            renum = rs.enumerateRecords(null, null, false);
            if (renum.hasNextElement()) break block19;
            renum.destroy();
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        try {
            int id = renum.nextRecordId();
            renum.destroy();
            byte[] rdata = rs.getRecord(id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(rdata));
            this.m_manifest_id = in.readInt();
            int amt = in.readShort();
            this.m_scores = new int[amt];
            int i = 0;
            while (i < amt) {
                this.m_scores[i] = in.readInt();
                ++i;
            }
            in.close();
        }
        catch (Throwable t) {
            try {
                System.out.println("Hiscore load error:");
                t.printStackTrace();
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.closeRecordStore();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            if (rs != null) {
                rs.closeRecordStore();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }
}

