/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Car;
import cellrace.ChoiceLine;
import cellrace.Polygon;
import cellrace.Score;
import cellrace.StraightLine;
import cellrace.Vector;
import utils.Comparable;
import utils.Messages;

public class Player
extends Messages
implements Comparable {
    private StraightLine vector = null;
    private Car car;
    double scale = 1.0;
    private static final int NO_ROTATION = 0;
    private static final int UP_ROTATION = 1;
    private static final int DOWN_ROTATION = 2;
    private boolean crashed = false;
    private boolean finished = false;
    private java.util.Vector history = new java.util.Vector();
    private Score score = new Score();
    private boolean canMove = true;
    private String name;

    public void clear() {
        this.vector = null;
        this.car.clear();
        this.crashed = false;
        this.finished = false;
        this.history.removeAllElements();
        this.score.clear();
        this.canMove = true;
        this.name = null;
    }

    public Player(String name) {
        this.setName(name);
    }

    public void setCar(Car car) {
        this.car = car;
    }

    public Car getCar() {
        return this.car;
    }

    public void setPosition(StraightLine vector) {
        this.history.addElement(vector.getStart());
        StraightLine oldVector = this.getPosition();
        this.vector = vector;
        this.firePropertyChange("SET_POSITON", oldVector, vector);
    }

    public java.util.Vector getHistory() {
        return this.history;
    }

    public StraightLine getPosition() {
        return this.vector;
    }

    public Polygon getSlipStreamBounds() {
        Polygon otherShape = new Polygon();
        Vector v1 = (Vector)this.getPosition().getStart().clone();
        Vector v2 = (Vector)this.getPosition().getDirection().clone();
        double width = (double)(this.getCar().getBounds().getWidth() * this.getCar().getCurrentGear()) * 1.5 + 10.0;
        double heigth = this.getCar().getBounds().getHeight() * this.getCar().getCurrentGear() + 4;
        v2.cross();
        v2.setLength(heigth / 2.0);
        v1.add(v2);
        otherShape.addPoint((int)v1.getX(), (int)v1.getY());
        v1 = (Vector)this.getPosition().getStart().clone();
        v2.setLength(-heigth / 2.0);
        v1.add(v2);
        otherShape.addPoint((int)v1.getX(), (int)v1.getY());
        v1 = (Vector)this.getPosition().getStart().clone();
        v2 = (Vector)this.getPosition().getDirection().clone();
        v2.setLength(width);
        v1.add(v2);
        Vector v3 = (Vector)v1.clone();
        v2.cross();
        v2.setLength(-heigth / 2.0);
        v1.add(v2);
        otherShape.addPoint((int)v1.getX(), (int)v1.getY());
        v2.setLength(-heigth / 2.0);
        v3.add(v2);
        otherShape.addPoint((int)v3.getX(), (int)v3.getY());
        return otherShape;
    }

    public Polygon getBounds(StraightLine straightLine) {
        double tolerance = 0.5;
        Polygon otherShape = new Polygon();
        Vector v1 = (Vector)straightLine.getStart().clone();
        Vector v2 = (Vector)straightLine.getDirection().clone();
        double width = (double)this.getCar().getBounds().getWidth() * tolerance;
        double heigth = (double)this.getCar().getBounds().getHeight() * tolerance;
        v2.cross();
        v2.setLength(heigth / 2.0);
        v1.add(v2);
        otherShape.addPoint((int)v1.getX(), (int)v1.getY());
        v1 = (Vector)straightLine.getStart().clone();
        v2.setLength(-heigth / 2.0);
        v1.add(v2);
        otherShape.addPoint((int)v1.getX(), (int)v1.getY());
        v1 = (Vector)straightLine.getStart().clone();
        v2 = (Vector)straightLine.getDirection().clone();
        v2.setLength(-width);
        v1.add(v2);
        Vector v3 = (Vector)v1.clone();
        v2.cross();
        v2.setLength(heigth / 2.0);
        v1.add(v2);
        otherShape.addPoint((int)v1.getX(), (int)v1.getY());
        v2.setLength(-heigth / 2.0);
        v3.add(v2);
        otherShape.addPoint((int)v3.getX(), (int)v3.getY());
        return otherShape;
    }

    public void shiftUp() {
        if (this.canShiftUp()) {
            this.getCar().incCurrentGear();
            this.firePropertyChange("SHIFT_UP", this.getCar().getCurrentGear() - 1, this.getCar().getCurrentGear());
        }
    }

    public boolean canShiftUp() {
        return this.getCar().getCurrentGear() + 1 < this.getCar().gearSize();
    }

    public void shiftDown() {
        if (this.canShiftDown()) {
            this.getCar().decCurrentGear();
            this.firePropertyChange("SHIFT_DOWN", this.getCar().getCurrentGear() + 1, this.getCar().getCurrentGear());
        }
    }

    public void holdShift() {
        this.firePropertyChange("SHIFT_HOLD", -1, this.getCar().getCurrentGear());
    }

    public boolean canShiftDown() {
        return this.getCar().getCurrentGear() > 0;
    }

    public boolean canHoldShift() {
        return this.getCar().getCurrentGear() != -1;
    }

    public void setCarScale(double d) {
        this.scale = d;
    }

    public double getCarScale() {
        return this.scale;
    }

    private ChoiceLine getChoice(int rotate, int gear, StraightLine position, boolean ignoreSlipstream) {
        if (rotate == 0) {
            Vector direction = (Vector)position.getDirection().clone();
            Vector start = (Vector)position.getStart().clone();
            direction.setLength(this.getCar().getGearDistance(gear, ignoreSlipstream));
            start.add(direction);
            return new ChoiceLine(start, direction);
        }
        Vector direction = (Vector)this.getPosition().getDirection().clone();
        Vector start = (Vector)this.getPosition().getStart().clone();
        direction.setLength(this.getCar().getGearDistance(gear, ignoreSlipstream));
        direction.rotate(rotate == 1 ? this.getCar().getGearAngle(gear, ignoreSlipstream) : -this.getCar().getGearAngle(gear, ignoreSlipstream));
        start.add(direction);
        return new ChoiceLine(start, direction);
    }

    public ChoiceLine[] getChoices() {
        return this.getChoices(0, this.getPosition());
    }

    public ChoiceLine[] getChoices(int gearBias, StraightLine position) {
        ChoiceLine[] choices = new ChoiceLine[9];
        if (this.canShiftDown()) {
            choices[1] = this.getChoice(0, this.getCar().getCurrentGear() - 1 + gearBias, position, true);
            choices[0] = this.getChoice(1, this.getCar().getCurrentGear() - 1 + gearBias, position, true);
            choices[2] = this.getChoice(2, this.getCar().getCurrentGear() - 1 + gearBias, position, true);
        }
        if (this.canHoldShift()) {
            choices[4] = this.getChoice(0, this.getCar().getCurrentGear() + gearBias, position, false);
            choices[3] = this.getChoice(1, this.getCar().getCurrentGear() + gearBias, position, true);
            choices[5] = this.getChoice(2, this.getCar().getCurrentGear() + gearBias, position, true);
        }
        if (this.canShiftUp()) {
            choices[7] = this.getChoice(0, this.getCar().getCurrentGear() + 1 + gearBias, position, false);
            choices[6] = this.getChoice(1, this.getCar().getCurrentGear() + 1 + gearBias, position, false);
            choices[8] = this.getChoice(2, this.getCar().getCurrentGear() + 1 + gearBias, position, false);
        }
        return choices;
    }

    public void setCrashed(boolean crashed) {
        boolean tmp = this.crashed;
        this.crashed = crashed;
        this.firePropertyChange("CRASH", tmp, crashed);
    }

    public boolean isCrashed() {
        return this.crashed;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
        this.firePropertyChange("FINISH", null, this);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public Score getScore() {
        return this.score;
    }

    public int compareTo(Object o) {
        int crash;
        Player player2 = (Player)o;
        int n = this.isCrashed() == player2.isCrashed() ? 0 : (crash = !this.isCrashed() ? -1 : 1);
        if (crash == 0) {
            int rank = this.getScore().getRank() - player2.getScore().getRank();
            if (rank == 0) {
                int round = player2.getScore().getRound() - this.getScore().getRound();
                if (round == 0) {
                    int intermediate = player2.getScore().getIntermediate() - this.getScore().getIntermediate();
                    if (intermediate == 0) {
                        int step = player2.getScore().getStep() - this.getScore().getStep();
                        if (step == 0) {
                            double distance = player2.getScore().getDistance() - this.getScore().getDistance();
                            System.err.print(String.valueOf(this.getName()) + " is in distance (round " + this.getScore().getRound() + ") step (" + this.getScore().getIntermediate() + ")" + this.getScore().getDistance());
                            System.err.print(String.valueOf(player2.getName()) + " is in distance (round " + player2.getScore().getRound() + ") inter (" + player2.getScore().getIntermediate() + ")" + player2.getScore().getDistance());
                            return distance < 0.0 ? -1 : (distance == 0.0 ? 0 : 1);
                        }
                        System.err.print(String.valueOf(this.getName()) + " is in step " + this.getScore().getStep());
                        System.err.print(String.valueOf(player2.getName()) + " is in step " + player2.getScore().getStep());
                        return step;
                    }
                    System.err.print(String.valueOf(this.getName()) + " is in inter " + this.getScore().getIntermediate());
                    System.err.print(String.valueOf(player2.getName()) + " is in inter " + player2.getScore().getIntermediate());
                    return intermediate;
                }
                System.err.print(String.valueOf(this.getName()) + " is in round " + this.getScore().getRound());
                System.err.print(String.valueOf(player2.getName()) + " is in round " + player2.getScore().getRound());
                return round;
            }
            return rank;
        }
        return crash;
    }

    public void setCanMove(boolean canMove) {
        this.canMove = canMove;
    }

    public boolean isCanMove() {
        return this.canMove;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }
}

