#ifndef libfhi_sdlsurface_include
#define libfhi_sdlsurface_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_surface.h"

namespace libfhi {

//############################################################################
// Luokka ####################################################################
//############################################################################

class sdlSurface : public Surface
{
  public:
    static const uint32_t DEFAULT_SDL_FLAGS;

  protected:
    void *sdls;

  public:
    sdlSurface();
    sdlSurface(int, int, int = 32, uint8_t = Surface::DEFAULT_FLAGS,
	uint32_t = DEFAULT_SDL_FLAGS);
    virtual ~sdlSurface();

    void adapt(void *);
    void blit(int, int, sdlSurface *);
    void blit(int, int, int, int, int, int, sdlSurface *);
    void refresh();
    int reserve(int, int, int, uint8_t, uint32_t);

    // Virtual methods
    virtual void flip();
    virtual void lock();
    virtual void null();
    virtual void unlock();
    virtual void unreserve();

    // Inline methods
    void* get_sdls()
    {
      return sdls;
    }

#ifdef LIBFHI_DEBUG
    static std::ostream& print_sdls_flags(std::ostream&, uint32_t);
#endif
};

//############################################################################
// Funktiot ##################################################################
//############################################################################

sdlSurface* set_mode(int, int, int, uint8_t = Surface::DEFAULT_FLAGS,
    uint32_t = sdlSurface::DEFAULT_SDL_FLAGS);
sdlSurface* sdlsurface_new(int, int, int, uint8_t = Surface::DEFAULT_FLAGS,
    uint32_t = sdlSurface::DEFAULT_SDL_FLAGS);

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

