#ifndef libfhi_png_include
#define libfhi_png_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_default.h"

namespace libfhi {

//############################################################################
// Globals ###################################################################
//############################################################################

extern int
  last_png_b,
  last_png_h,
  last_png_w;

//############################################################################
// Functions #################################################################
//############################################################################

extern LIBFHI_PNG_BYTE* read_png(const char*);
extern bool write_png(int, int, int, void*, const char*);

//############################################################################
// Inline functions ##########################################################
//############################################################################

/** Return the bit depth of last png load.
 * @return Value as int.
 */
static inline int get_last_png_b()
{
  return last_png_b;
}

/** Return the height of last png load.
 * @return Value as int.
 */
static inline int get_last_png_h()
{
  return last_png_h;
}

/** Return the width of last png load.
 * @return Value as int.
 */
static inline int get_last_png_w()
{
  return last_png_w;
}

//############################################################################
// End #######################################################################
//############################################################################

}
#endif

