#ifndef turret_h
#define turret_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "entitybase.h"

#include "libfhi.h"

//############################################################################
// Define ####################################################################
//############################################################################

// Forward declaration.
class CollisionMap;
class Entity;
class EntityArchtype;
class WeaponSlot;

//############################################################################
// Class #####################################################################
//############################################################################

/** Turret is a mobile rotating piece attached into an entity that does firing
 * on it's own. Whenever host entity rotates, turrets must also rotate.
 */
class Turret :
  public EntityBase
{
  private:
    /** Base entity archtype class. */
    EntityArchtype *base_class;

    /** Host entity pointer. */
    Entity *host;

    /** Collision maps of this. */
    std::vector<CollisionMap*> maps;

    /** Model of this. */
    std::vector<libfhi::PostModel*> models;

    /** Weapons in this. */
    std::vector<WeaponSlot*> weaponslots;

    /** Position relative to host. */
    libfhi::Vector2 pos;

    /** Height relative to host. */
    float zpos;

    /** Minimum angle. */
    int min_dir;

    /** Maximum angle. */
    int max_dir;

    /** Direction (angle) of this. */
    int dir;

    /** Charge times now. */
    int charge_now;

    /** Previous charge time. */
    int charge_last;

    /** Target this turret is looking at. */
    Entity *ai_target;

    /** Last target select. */
    int ai_last_select;

  public:
    Turret(const libfhi::Vector2&, float, int, int, int, EntityArchtype*);
    Turret(Turret*, Entity*);
    virtual ~Turret();

  public:
    void add(CollisionMap*);
    void add(libfhi::Mesh*);
    void add(WeaponSlot*);
    void ai_turret(const libfhi::Vector2&, const libfhi::Vector2&, uint16_t);
    void draw(const libfhi::Vector2&, uint16_t);
    void insert_collision_maps(const libfhi::Vector2&, float, float,
	uint16_t);
    void invoke_death();

  public:
    inline EntityArchtype* get_base_class();
    inline const libfhi::Vector2& get_pos();

  public:
    virtual Entity* get_entity();
    virtual void take_damage(int);
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get base class of this.
 * @return Pointer to the base class.
 */
EntityArchtype* Turret::get_base_class()
{
  return this->base_class;
}

/** Get the position of this.
 * @return Reference to the position vector.
 */
const libfhi::Vector2& Turret::get_pos()
{
  return this->pos;
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

