#ifndef textonplayfield_h
#define textonplayfield_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

#include <string>

//############################################################################
// Class #####################################################################
//############################################################################

/** Text-on-playfield is mostly used for displaying scores.
 */
class TextOnPlayfield
{
  public:
    /** Lifetime of text objects on-screen. */
    static const int LIFETIME = 100;

    /** Starting color, will fade to transparent later. */
    static const int COLOR_R = 200;

    /** Starting color, will fade to transparent later. */
    static const int COLOR_G = 200;

    /** Starting color, will fade to transparent later. */
    static const int COLOR_B = 200;

    /** Starting color transparency. */
    static const float COLOR_A;

    /** The decrement value. */
    static const float DECREMENT_A;

  private:
    /** Game position of displayed thingy. */
    libfhi::Vector2 pos;

    /** Text to display. */
    std::string text;

    /** Alpha color component of this. */
    float alpha;

    /** Time left. */
    int lifetime;

  public:
    TextOnPlayfield(const libfhi::Vector2&, const std::string&);
    ~TextOnPlayfield();

    // Inline
  public:
    inline int get_color() const;
    inline const libfhi::Vector2& get_pos() const;
    inline const char* get_text() const;
    inline bool tick();
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get the color of this (as an integer).
 * @return Integer representation of color.
 */
int TextOnPlayfield::get_color() const
{
  return libfhi::Surface::makecol4(COLOR_R, COLOR_G, COLOR_B,
      lrintf(this->alpha));
}

/** Get the position.
 * @return Position as const reference.
 */
const libfhi::Vector2& TextOnPlayfield::get_pos() const
{
  return this->pos;
}

/** Get the character string representation.
 * @return String.
 */
const char* TextOnPlayfield::get_text() const
{
  return this->text.c_str();
}

/** Decrement lifetime (and color gamma).
 */
bool TextOnPlayfield::tick()
{
  this->alpha -= TextOnPlayfield::DECREMENT_A;

  return (this->lifetime-- > 0);
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

