#ifndef ABSORB_MUSIC_INCLUDE
#define ABSORB_MUSIC_INCLUDE

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

#include "SDL.h"
#include "SDL_mixer.h"

//############################################################################
// Class #####################################################################
//############################################################################

/** Music handles the playing of one music file. When done, it should be
 * deleted and new one reserved for the next music.
 */
class Music :
  public libfhi::Singleton<Music>
{
  public:
    /** The default volume level Music class will be initialized with. */
    static const int DEFAULT_VOLUME = MIX_MAX_VOLUME;

  public:
    Music();
    ~Music();

    void Init(const char*, int = MIX_MAX_VOLUME);
    void Play() const;
    static void Stop();
    int SetVolume(int vol);

  private:
    /** Volume value. */
    int volume;

    /** The music file pointer. */
    Mix_Music *music;

    /** For checks do we need to begin playing again. */
    std::string music_file;
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

