#ifndef ingamemenu_h
#define ingamemenu_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "menu.h"

#include "libfhi.h"

//############################################################################
// Class #####################################################################
//############################################################################

/** Main menu class takes care of displaying the main menu with some fancy
 * crap beside it.
 */
class InGameMenu :
  public Menu,
  public libfhi::Singleton<InGameMenu>
{
  private:
    /** x position of displayed text. */
    float disp_text_x;

    /** y position of displayed text. */
    float disp_text_y;

  public:
    InGameMenu();
    ~InGameMenu();

    // Virtual methods.
    virtual void draw(libfhi::Surface*);
    virtual void keydown(int);
    virtual void tick();
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

