#ifndef thurster_h
#define thurster_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

//############################################################################
// Define ####################################################################
//############################################################################

// Forward declaration.
class Effect;

//############################################################################
// Class #####################################################################
//############################################################################

/** The class that determines thurst. Spawns thurst projectiles when invoked.
 */
class Thurster
{
  private:
    /** Position (relative to host. */
    libfhi::Vector2 pos;

    /** Thurstvector (speed AND scatter). */
    libfhi::Vector2 thurstvector;    

    /** Effect pointer. */
    Effect *effect;

  public:
    Thurster(const libfhi::Vector2&, float, int, const char*);
    ~Thurster();

  public:
    void fire(const libfhi::Vector2&, const libfhi::Vector2&, uint16_t);
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

