#include "music.h"

#include "data.h"

#include <iostream>

//############################################################################
// Construction ##############################################################
//############################################################################

/** Deault constructor. Does not initialize music in itself.
 */
Music::Music()
  : volume(DEFAULT_VOLUME), music(NULL)
{
  // Do nothing.
}

/** Default destructor.
 */
Music::~Music()
{
  if(this->music)
  {
    Mix_FreeMusic(this->music);
  }
}

/** Default constructor. Load a given music file with given volume.
 * @param filename Filename to load.
 * @param vol Volume level.
 */
void Music::Init(const char *filename, int vol)
{
  // Do not change music if not needed.
  if(this->music_file.compare(filename) == 0)
  {
    return;
  }
  this->music_file = std::string(filename);

  // Free previous music.
  if(music)
  {
    Mix_FreeMusic(this->music);
  }

  // Change to data directory.
  Data::chdir_to_datadir();

  // Load new music.
  music = Mix_LoadMUS(filename);

  if(!music)
  {
    std::cerr << "Error: music file \"" << filename << "\" not found!\n";
  }
  else
  {
    this->SetVolume(vol);
  }

  // Start playing the loaded music.
  this->Play();
}

/** Start playing the music.
 */
void Music::Play() const
{
  Mix_VolumeMusic(volume);
  Mix_PlayMusic(music, -1);

  std::cout << "Playing music file: \"" << this->music_file << "\"\n";
}

/** Stop playing the music.
 */
void Music::Stop()
{
  Mix_HaltMusic();
}

/** Change the music volume.
 * @param vol New volume setting.
 * @return Old volume setting.
 */
int Music::SetVolume(int vol)
{
  volume = vol;
  return Mix_VolumeMusic(volume); // Returns the old value
}

//############################################################################
// End #######################################################################
//############################################################################

