#include "mainmenu.h"

#include "commands.h"
#include "data.h"
#include "music.h"
#include "options.h"

#include "SDL.h"

//############################################################################
// Construction ##############################################################
//############################################################################

MainMenu::MainMenu()
  : Menu("Absorb")
{
  // Set menu music on construction.
  this->return_to();

  MenuItem *new_game = new MenuItem("New game");
  new_game->add_item(new MenuItem("< Back"));
  new_game->add_item(new MenuItem("Challenge", command_challenge));
  //new_game->add_item(new MenuItem("Story mode", command_new_game_story_mode));
  new_game->add_item(new MenuItem("Survival", command_new_game_survival));

  this->menu.add_item(new_game);
  //this->menu.add_item(new MenuItem("High scores", command_high_scores));
  this->menu.add_item(new MenuItem("Encyclopedia", command_encyclopedia));
  this->menu.add_item(new MenuItem("Quit", command_quit));

  this->logo_tex = Data::load_texture("absorb_logo.png");
}

MainMenu::~MainMenu()
{
  /* Do nothing. */
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Implementation of draw.
 */
void MainMenu::draw(libfhi::Surface *screen)
{
  screen->set_boundary(0, 0, screen->get_h() - 1, screen->get_h() - 1);
  screen->select_2d();
  libfhi::Surface::draw_texture(0, 0, screen->get_h() - 1,
      screen->get_h() - 1, this->logo_tex);

  // Fallback to draw menu.
  Menu::draw(screen);
}

/** Implementation of keydown.
 * @param key Key pressed.
 */
void MainMenu::keydown(int key)
{
  if((key == SDLK_ESCAPE) || (key == Options::key_absorb))
  {
    MenuItem *parent = this->current->get_parent();

    if((parent == NULL) || (parent->get_parent() == NULL))
    {
      command_quit();
      return;
    }
  }

  Menu::keydown(key);
}

/** Returning here reloads the music.
 */
void MainMenu::return_to()
{
  Music *musa = Music::instance_get();
  musa->Init("music/Eino_Keskitalo_-_Pelle_Pelottava.ogg");
}

/** Implementation of tick.
 */
void MainMenu::tick()
{
  // Fallback to menu.
  Menu::tick();
}

//############################################################################
// End #######################################################################
//############################################################################

