#include "levelitem.h"

#include "data.h"

//############################################################################
// Construction ##############################################################
//############################################################################

/** Default constructor.
 * @param f Filename.
 * @param n Name.
 * @param d Description.
 * @param t Texture filename.
 */
LevelItem::LevelItem(const char *f, const char *n, const char *d,
    const char *t) :
  filename(f), name(n), description(d)
{
  this->tex = Data::load_texture(t);
}

/** Do not erase texture upon deletion, actually, pretty much do nothing.
 */
LevelItem::~LevelItem()
{
  // Do nothing.
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Asks about need to update score.
 * @param op New score.
 * @return True if need, false if not.
 */
bool LevelItem::need_update_score(int op) const
{
  return (op > this->best_score);
}

/** Asks about need to update time.
 * @param op New time.
 * @return True if need, false if not.
 */
bool LevelItem::need_update_time(int op) const
{
  return (op < this->best_time);
}

/** Set new score and author.
 * @param val New value.
 * @param author New author.
 */
void LevelItem::set_best_score(int val, const std::string &author)
{
  this->best_score = val;
  this->author_score = author;
}

/** Set new time and author.
 * @param val New value.
 * @param author New author.
 */
void LevelItem::set_best_time(int val, const std::string &author)
{
  this->best_time = val;
  this->author_time = author;
}

//############################################################################
// End #######################################################################
//############################################################################

