#ifndef eventhandler_h
#define eventhandler_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

//############################################################################
// Class #####################################################################
//############################################################################

/** EventHandler is a class that processes events and displays stuff on
 * screen. It is mainly an inherited class, most of the functionality is
 * written to derieved classes.
 */
class EventHandler
{
  public:
    virtual ~EventHandler();

    /** Update the state of this event handler to the screen.
     * Calculated only when time allows.
     */
    virtual void draw(libfhi::Surface*) = 0;

    /** Receive a keypress command.
     * Calculated every frame.
     * @param key Key command index.
     */
    virtual void keydown(int key) = 0;

    /** Receive a key release command.
     * Calculated every frame.
     * @param key Key command index.
     */
    virtual void keyup(int key);

    /** Performed when returning to a handler that supposedly was previously
     * left.
     */
    virtual void return_to();

    /** Perform all calculation neccessary for the consistency.
     * Calculated every frame.
     */
    virtual void tick();
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

