#ifndef entitybase_h
#define entitybase_h

//############################################################################
// Definition ################################################################
//############################################################################

// Forward declaration.
class Entity;

//############################################################################
// Class #####################################################################
//############################################################################

/** Entitybase is the common attributes for both turrets and entities. It
 * basically exists to allow both turrets and entities to take damage through
 * a similar framework and allow for turret destruction without the hassle
 * that would be subentity architecture. This is a lazy choise and shall
 * hopefully be fixed in the future.
 */
class EntityBase
{
  protected:
    /** Faction of this. */
    int faction;

    /** Life of this. */
    int life;

  public:
    EntityBase(int, int);
    virtual ~EntityBase();

  public:
    virtual Entity* get_entity() = 0;
    virtual void take_damage(int) = 0;

  public:
    inline int get_faction() const;
    inline int get_life() const;
};

//############################################################################
// Inline methods ############################################################
//############################################################################

/** Get current faction.
 * @return life.
 */
int EntityBase::get_faction() const
{
  return this->faction;
}

/** Get the current life.
 * @return life.
 */
int EntityBase::get_life() const
{
  return this->life;
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

