#ifndef encyclopediapage_h
#define encyclopediapage_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "enums.h"

#include "libfhi.h"

#include <string>

//############################################################################
// Class #####################################################################
//############################################################################

class EncyclopediaPage
{
  public:
    /** Left border of the text box. */
    static const float ENCYCLOPEDIA_X1;

    /** Top border of the text box. */
    static const float ENCYCLOPEDIA_Y1;

    /** Right border of the text box. */
    static const float ENCYCLOPEDIA_X2;

    /** Bottom border of the text box. */
    static const float ENCYCLOPEDIA_Y2;
    
  private:
    /** Page name. */
    std::string name;

    /** Textual content. */
    std::string content_text;

    /** The wireframe mesh that requires deletion when we're done. */
    libfhi::Mesh *normal_mesh;

    /** The wireframe mesh that requires deletion when we're done. */
    libfhi::Mesh *wireframe_mesh;

    /** Header image. */
    libfhi::Texture *content_header;

    /** Content image. */
    libfhi::Texture *content_image;

    /** Content specification image. */
    libfhi::sdlSurface *content_specification;

    /** Left border of the text box. */
    float x1;

    /** Top border of the text box. */
    float y1;

    /** Type of this encyclopedia page. */
    EncyclopediaEnum type;

    /** Longest radius of the mesh in question. */
    float longest_radius;

  public:
    EncyclopediaPage(const char*);
    ~EncyclopediaPage();

  private:
    void display_model(int, int, int, int, libfhi::Mesh*, libfhi::Surface*);

  public:
    void draw(libfhi::Surface*);

  public:
    inline const std::string& get_name() const;
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get the name of this.
 * @return Name as const string reference.
 */
const std::string& EncyclopediaPage::get_name() const
{
  return this->name;
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

