#ifndef data_h
#define data_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

//############################################################################
// Define ####################################################################
//############################################################################

// Forward declaration.
class CollisionMap;
class Effect;
class EntityArchtype;
class ParticleSystem;
class Sample;
class WeaponMount;
class Weapon;

//############################################################################
// Class #####################################################################
//############################################################################

/** Data loader is just an easy abstraction to ensure, that all data needed
 * ingame is loaded on time (since static variables tend to have problems).
 * Also, one thing we really, really do need is the chdir to data directory,
 * so we do not have to care about it while loading files.
 */
class Data
{
  private:
    /** Tells if we are in the data directory. */
    static bool in_datadir;

  public:
    static void chdir_to_datadir();
    static CollisionMap* load_cmap(const char*);
    static Effect* load_eff(const char*);
    static EntityArchtype* load_ent(const char*);
    static libfhi::Mesh* load_msh(const char*);
    static WeaponMount* load_mount(const char*);
    static ParticleSystem* load_part(const char*);
    static Sample* load_sample(const char*);
    static libfhi::Texture* load_texture(const char*);
    static Weapon* load_weap(const char*);

    // Templates.
  private:
    template <class Type> static Type* load_template(const char*);
};

//############################################################################
// Templates #################################################################
//############################################################################

/** The basic loader function for generic canonical database stuff.
 * @param str Filename of the laded thingy.
 */
template <class Type>
Type* Data::load_template(const char *str)
{
  Type *ret = Type::canon_get(str);
  if(ret)
  {
    return ret;
  }

  Data::chdir_to_datadir();

  if(!libfhi::fexists(str))
  {
    std::cerr << "Warning: file not found: \"" << str << "\n";
    return NULL;
  }

  return Type::canon_load(str);
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

