#ifndef libfhi_glsurface_include
#define libfhi_glsurface_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_sdlsurface.h"

namespace libfhi {

//############################################################################
// Luokka ####################################################################
//############################################################################

class glSurface : public sdlSurface
{
  private:
    static bool opengl_initialized;

  protected:
    // OpenGL drawing primitives.
    static void gl_setpixel(int, int, int);
    static void gl_hline(int, int, int, int);
    static void gl_vline(int, int, int, int);
    static void gl_line(int, int, int, int, int);
    static void gl_rect(int, int, int, int, int);
    static void gl_rect_contour(int, int, int, int, int);
    static void gl_triangle_flat(int);
    static void gl_triangle_gouraud();
    static void gl_poly_flat(int);
    static void gl_poly_gouraud();
    static void gl_zbuf_line_flat(int);
    static void gl_zbuf_line_gouraud();
    static void gl_zbuf_poly_flat(int);
    static void gl_zbuf_poly_gouraud();

    // Wrap-around when using the state machine without clipping.
    static void gl_nc_zbuf_spot(int);
    static void gl_nc_triangle_flat(int);
    static void gl_nc_triangle_gouraud();
    static void gl_nc_poly_flat(int);
    static void gl_nc_poly_gouraud();
    static void gl_nc_zbuf_line_flat(int);
    static void gl_nc_zbuf_line_gouraud();
    static void gl_nc_zbuf_poly_flat(int);
    static void gl_nc_zbuf_poly_gouraud();

    // High-level.
    static int gl_draw_text(int, int, int, Font*, const char*);
    static void gl_draw_model(PostModel*);
    static void gl_draw_texture(int, int, int, int, Texture*);

  public:
    glSurface();
    glSurface(int, int, int, uint32_t = 0);
    virtual ~glSurface();

    // Virtual methods
    virtual void clear(int);
    virtual void clear(uint16_t);
    virtual void clear(int, uint16_t);
    virtual void flip();
    virtual void lock();
    virtual void null();
    virtual void reserve(int, int, int, uint32_t = 0);
    virtual void select();
    virtual void unlock();
    virtual void unreserve();

    // 3D-utility (virtual and static)
    virtual void select_2d();
    virtual void select_3d();
    virtual void set_camera(Camera*);
    virtual void set_light(Light*);

    // Inline methods.
  public:
    static inline bool is_opengl_initialized();
};

//############################################################################
// Functions #################################################################
//############################################################################

glSurface* glsurface_new(int, int, int, uint32_t = 0);

//############################################################################
// Inline ####################################################################
//############################################################################

/** Tell if OpenGL has been initialized.
 * @param True if yes, false if no.
 */
bool glSurface::is_opengl_initialized()
{
  return glSurface::opengl_initialized;
}

//############################################################################
// End #######################################################################
//############################################################################

}
#endif

