#ifndef libfhi_boundary_include
#define libfhi_boundary_include

//############################################################################
// Includet ##################################################################
//############################################################################

#include "libfhi_default.h"

namespace libfhi {

//############################################################################
// Luokka ####################################################################
//############################################################################

class Boundary
{
  friend class Point;
  friend class Surface;
  friend class glSurface;

  public:
    static const float
      DEF_CLIP_Z_NEAR,
      DEF_CLIP_Z_FAR,
      DEF_VIEW_RATIO;

    static const uint16_t
      ZBUFFER_MAX = 65534;

#ifdef LIBFHI_DEBUG
  public:
    DEBUG_PRINT_PROTOTYPE(Boundary)
#endif

  /*
   * These constants give control over z-buffer and views. Z-buffer is only
   * 16 bits and will be scaled according to this.
   */
  private:
    int xmin_i, ymin_i, xmax_i, ymax_i;
    float xmin_f, ymin_f, xmax_f, ymax_f, perspective, xcenter, ycenter,
	  zmin, zmax, zmul;
 
  public:
    float glu_aspect() const;
    float glu_fov() const;
    void set(int, int, int, int);
    void set(float, float, float, float = DEF_CLIP_Z_NEAR,
	float = DEF_CLIP_Z_FAR);

    // Inlinet
    inline bool below_x(int op) const
    {
      return (op < xmin_i);
    }
    inline bool below_x(float op) const
    {
      return (op < xmin_f);
    }
    inline bool above_x(int op) const
    {
      return (op > xmax_i);
    }
    inline bool above_x(float op) const
    {
      return (op > xmax_f);
    }
    inline bool below_y(int op) const
    {
      return (op < ymin_i);
    }
    inline bool below_y(float op) const
    {
      return (op < ymin_f);
    }
    inline bool above_y(int op) const
    {
      return (op > ymax_i);
    }
    inline bool above_y(float op) const
    {
      return (op > ymax_f);
    }
    inline bool below_z(float op) const
    {
      return (op < zmin);
    }
    inline bool above_z(float op) const
    {
      return (op > zmax);
    }
    inline float get_xcenter() const
    {
      return (xmax_f - xmin_f) / 2.0f;
    }
    inline float get_ycenter() const
    {
      return (ymax_f - ymin_f) / 2.0f;
    }
    inline float glu_near() const
    {
      return -1.0f * this->zmax;
    }
    inline float glu_far() const
    {
      return -1.0f * this->zmin;
    }
    inline int get_heigth() const
    {
      return ymax_i - ymin_i + 1;
    }
    inline int get_width() const
    {
      return xmax_i - xmin_i + 1;
    }
    inline int gl_vpx() const
    {
      return xmin_i;
    }
    inline int gl_vpy(int op) const
    {
      return op - ymax_i - 1;
    }
};

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

