#include "libfhi_fixed.h"

using namespace libfhi;

//############################################################################
// Constants #################################################################
//############################################################################

const float Fixed::FIXED_MUL = 32768.0;

//############################################################################
// Debug #####################################################################
//############################################################################

#ifdef LIBFHI_DEBUG

/** Print this into a given stream, then return it.
 * @param s [in] Stream to print to.
 * @return Modified stream.
 */
std::ostream& Fixed::print(std::ostream &s) const
{
  // If even.
  if(!(this->val & 0x0000FFFF))
  {
    return s << (this->val >> LIBFHI_FIXED_SHIFT);
  }
  // Otherwise not so great printing.
  return s << (this->val >> LIBFHI_FIXED_SHIFT) << '.' <<
    (this->val & 0x0000FFFF);
}

#endif

//############################################################################
// Loppu #####################################################################
//############################################################################

