float4x4 wvpMatrix : WORLDVIEWPROJECTION;

float darkness 
< string UIWidget = "Slider"; 
  float UIStep = 0.1f;
  float UIMin = 0.0f;
  float UIMax = 100.0f;
  string UIName = "Darkness";
>;

float darkness_2
< string UIWidget = "Slider"; 
  float UIStep = 0.1f;
  float UIMin = 0.0f;
  float UIMax = 100.0f;
  string UIName = "Darkness2";
>;

struct VertexOutput
{
	float4 position : POSITION;
	float4 color : COLOR;
};

VertexOutput VS_BlackOverlay( float3 position : POSITION )
{
	VertexOutput OUT;
	
	OUT.position = float4( position, 1.0f );
	OUT.color.rgb = 0.0f;
	OUT.color.a = 1.0f - ( darkness / 100.0f );
	
	return OUT;
}

VertexOutput VS_ObjectOverlay( float3 position : POSITION )
{
	VertexOutput OUT;
	
	OUT.position = mul( float4( position, 1.0f ), wvpMatrix );
	OUT.color.rgb = 0.0f;
	OUT.color.a = darkness_2 / 100.0f;
	
	return OUT;
}

technique Overlay
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_BlackOverlay();
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = invSrcAlpha;
		
		ZWriteEnable = false;
		ZEnable = false;
	}
}

technique ObjectOverlay
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_ObjectOverlay();
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = invSrcAlpha;
		
		ZWriteEnable = false;
		ZEnable = false;
	}
}

technique DoOverlay< bool quad=true; string material="overlay"; >
{
}