float4x4 comboMatrix : WorldViewProjection;

half4	materialColor = { 1.0f, 1.0f, 1.0f, 1.0f };
texture texture_0;

float	darkness;

sampler texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput
{
	float3 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput
{
	float4 position : POSITION;
	float2 uvCoord : TEXCOORD0;
};

struct VertexOutputDarkness
{
	float4 position : POSITION;
	float2 uvCoord : TEXCOORD0;
	float4  darkness : COLOR;
};

struct VertexOutputColor
{
	float4 position : POSITION;
	float4 color	: COLOR;
};


VertexOutput VS_VertexUVTransform( VertexInput IN )
{
	VertexOutput OUT;
	OUT.position = mul( float4(IN.position, 1.0f), comboMatrix );
	OUT.uvCoord = IN.uvCoord;
	return OUT;
}


VertexOutputDarkness VS_VertexUVTransformDark( VertexInput IN )
{
	VertexOutputDarkness OUT;
	OUT.position = mul( float4(IN.position, 1.0f), comboMatrix );
	OUT.uvCoord = IN.uvCoord;
	OUT.darkness.rgb = 1.0f;
	OUT.darkness.a = darkness / 100.0f;
	return OUT;
}

float4 PS_Dark( VertexOutputDarkness IN ) : COLOR
{
	return tex2D( texture_0Sampler, IN.uvCoord ) * IN.darkness;
}

VertexOutputColor VS_VertexTransform( float3 position : POSITION )
{
	VertexOutputColor OUT;
	OUT.color = materialColor;
	OUT.position = mul( float4(position, 1.0f), comboMatrix );
	return OUT;
}

float4 PS_Texture( VertexOutput IN ) : COLOR
{
	return tex2D( texture_0Sampler, IN.uvCoord );
};


technique PosMaterial
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		PixelShader = NULL;
		
		ZEnable = false;
	}
}

technique TexturedNoZ
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexUVTransform();
		PixelShader = compile ps_1_1 PS_Texture();
		
		ZEnable = false;
	}
}

technique TexturedDarkness
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexUVTransformDark();
		PixelShader = compile ps_1_1 PS_Dark();
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
		
		ZEnable = false;
	}
}

technique TexturedDarknessFF
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexUVTransformDark();
		
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
		
		Texture[0] = <texture_0>;
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = Linear;
		
		ZEnable = true;
		ColorVertex = true;	
	}
}