TNR = 15
TNPR = 7
TRINGL = 60.0
TUNNEL_WIDTH = 32
function P_hypertunnelp() {
    OFFSET_VECTOR.reset()
    document.getElementById('d').style.backgroundColor = 'white'
    flash = new Div('white', 512, 384)
    flash.img.style.zIndex = 8080
    flash.moveXY(256,192)
    flash.hide()
    rings = new Array(TNR)
    pix = new Array(TNR * TNPR)
    for (var i = 0; i < TNR; ++i) {
        rings[i] = new Array(TNPR)
        for (var j = 0; j < TNPR; ++j) {
            var angle = j / TNPR * 2 * Math.PI  + i / 4
            var rad = 1.0
            with (Math) rings[i][j] = new Vector3D(TRINGL * i / TNR - TRINGL / 2, rad * sin(angle), rad * cos(angle))
            pix[j + i * TNPR] = new Pic('data/invp.png', TUNNEL_WIDTH, TUNNEL_WIDTH)
        }
    }
    P_hypertunnel(0)
}
function P_hypertunnele() {
    flash.free()
    for (var i = 0; i < TNR; ++i) {
        for (var j = 0; j < TNPR; ++j) {
            pix[j + i * TNPR].free()
        }
        delete rings[i]
    }
    delete rings
    delete pix
    ROTATION_MATRIX.reset()
    OFFSET_VECTOR.x = 0
    OFFSET_VECTOR.y = 0
    OFFSET_VECTOR.z = 0
}

function P_hypertunnel(pttime) {
    OFFSET_VECTOR.z = -pttime / 70  + 60
    rotate3d2(Math.PI / 2)
    rotate3d3(pttime/600)
    if (pttime < 2000) {
        flash.show()
        flash.alpha(1 - (pttime) / 2000)
    }
    else flash.hide()
    for (var i = 0; i < TNR; ++i) {
        for (var j = 0; j < TNPR; ++j) {
            var tmp = new Vector3D()
            tmp.x = rings[i][j].x
            tmp.y = rings[i][j].y
            tmp.z = rings[i][j].z
            tmp.transform(ROTATION_MATRIX)
            tmp.x += OFFSET_VECTOR.x
            tmp.y += OFFSET_VECTOR.y
            tmp.z += OFFSET_VECTOR.z
            if (tmp.z > -1.8) {
                pix[j + i * TNPR].show()
                pix[j + i * TNPR].move3d(rings[i][j], 1)
            }
            else 
                pix[j + i * TNPR].hide()
        }
    }
    ROTATION_MATRIX.reset()
}
