/* torus scene */

var GREET_SLOT_COUNT;
var GREET_WIDTH = 150;
var GREET_HEIGHT = 48;
var GREET_FADE_TIME = 1200;
var GREET_TIME = 4800;

var torusScene = {
	subjects: [
		{
			transform: yRotation(function(t) {return Math.PI * (t % 4000) / 2000;}),
			subjects: [
				{ light: [-2, 3, 5] }
			]
		},
		{
			transform: yRotation(function(t) {return Math.PI * (t % 20000) / 10000;}),
			subjects: [
				makeTorus(3, 0.8, 12, 6, dutchColourScheme),
				{generate: makeFigureEight}
			]
		}
	]
}

var particleT = [];
var particleDz = [];
var obeliskImg;
var cyanDot;
var greets = [];
var greetRunners = [];
var greetSlots = [];
var currentGreet = 0;

function makeFigureEight(t) {
	var vert = [];
	for (i = 0; i < 100; i++) {
		u = particleT[i] + t / 8000;
		vert.push([4 * Math.sin(u), 2 * Math.sin(2*u), Math.cos(u) + particleDz[i]]);
	}
	return { model: renderSprites, v: vert, image: cyanDot, size: 64 }
}

function initTorusScene() {
	for (i = 0; i < 100; i++) {
		particleT.push(Math.random() * 2 * Math.PI);
		particleDz.push(Math.random() / 2);
	}
	windowImg = new Image();
	windowImg.src = 'data/window.png';
	cyanDot = new Image();
	cyanDot.src = 'data/cyan_dot.png';
	
	for (i = 0; i < 23; i++) {
		greets[i] = new Image();
		greets[i].src = 'data/greet' + i + '.png';
	}
}

function startTorusScene() {
	AMBIENT_LEVEL = 100;
	PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 0;
	FOC = 8;
	GREET_SLOT_COUNT = Math.floor(CANVAS_HEIGHT / GREET_HEIGHT) - 4; /* top and bottom two slots look ugly */
	for (i = 0; i < 4; i++) {
		greetRunners[i] = new GreetRunner(i * 1000);
	}
	
}

function GreetRunner(delay) {
	this.img = null;
	this.slot = -1;
	this.currentEventLength = delay;
	this.currentEventStart = 0;
	this.started = 0;
	this.element = document.createElement('img');
	this.element.className = 'greet';
	props.appendChild(this.element);
}
GreetRunner.prototype.run = function(t) {
	var lifetime = t - this.currentEventStart;
	if (lifetime > this.currentEventLength) {
		/* new greet */
		greetSlots[this.slot] = false;
		this.img = greets[currentGreet++];
		if (this.img) {
			this.element.src = this.img.src;
			do {
				this.slot = Math.floor(Math.random() * GREET_SLOT_COUNT) + 2; /* +2 to compensate for the -4 earlier */
			} while (greetSlots[this.slot]);
			greetSlots[this.slot] = true;
			this.currentEventStart += this.currentEventLength;
			this.currentEventLength = GREET_TIME + Math.random() * 500;
			lifetime = t - this.currentEventStart;
		} else {
			this.img = null;
			this.element.style.display = 'none';
			this.currentEventStart += this.currentEventLength;
			this.currentEventLength = 10000;
		}
	}
	if (this.img) {
		if (lifetime < GREET_FADE_TIME) {
			var opacity = (lifetime / GREET_FADE_TIME);
			var height = GREET_HEIGHT + 300 * (1 - opacity);
			this.element.style.opacity = opacity;
			this.element.style.left = CANVAS_WIDTH - GREET_WIDTH + 'px';
			this.element.width = GREET_WIDTH;
			this.element.height = height;
			this.element.style.top = (this.slot * GREET_HEIGHT) - (height - GREET_HEIGHT) /2 + 'px';
		} else if (lifetime > (this.currentEventLength - GREET_FADE_TIME)) {
			var opacity = ((this.currentEventLength - lifetime) / GREET_FADE_TIME);
			var height = GREET_HEIGHT + 300 * (1 - opacity);
			this.element.style.opacity = opacity;
			this.element.style.left = CANVAS_WIDTH - GREET_WIDTH + 'px';
			this.element.width = GREET_WIDTH;
			this.element.height = height;
			this.element.style.top = (this.slot * GREET_HEIGHT) - (height - GREET_HEIGHT) /2 + 'px';
		} else {
			this.element.style.opacity = 1;
			this.element.style.left = CANVAS_WIDTH - GREET_WIDTH + 'px';
			this.element.width = GREET_WIDTH;
			this.element.height = GREET_HEIGHT;
			this.element.style.top = (this.slot * GREET_HEIGHT) + 'px';
		}
	}
}

function doTorusScene(t) {
	ctx.drawImage(windowImg, 0, 0);
	var camera = [-2 , 3, -6 + Math.sin(t/3434)];
	var lookingAt = [2, 0, 0];
	
	renderFrame(torusScene, camera, lookingAt, t);
	for (var i = 0; i < greetRunners.length; i++) {
		greetRunners[i].run(t);
	}
}