/* Lighting models and core scene renderer */

var LIGHT_SOLID = 0;
var LIGHT_LAMBERTIAN = 1;
var LIGHT_PHONG = 2;

var lights;
var renderQueue; /* list of polys approximately ordered by Z */
var perspectiveScale;
var AMBIENT_LEVEL;

/* do per-frame initialisation and perform render of the scene */
/* scene = scene graph;
camera = vector indicating position of camera;
lookingAt = vector indicating where camera is pointing;
t = current time */
function renderFrame(scene, camera, lookingAt, t, doHorizon) {
	lights = [];
	renderQueue = [];
	var worldMatrix = makeCameraMatrix(camera, lookingAt);
	// perspectiveScale = (CANVAS_WIDTH / VIEW_WIDTH) * FOC;

	render(scene, worldMatrix, t);
	
	if (doHorizon) {
		/* yeah, this is a totally weird place in the code to do this. I couldn't figure out anywhere better */
		//var horizon = [lookingAt[0] * 10000, 0, lookingAt[2] * 10000];
		var horizon = [lookingAt[0] > camera[0] ? 10000 : -10000, 0, lookingAt[2] > camera[2] ? 10000 : -10000];
		var horizon_y = project(transformVector(horizon, worldMatrix))[1];
		try {
		paintHorizon(horizon_y);
		} catch(err) { alert (horizon_y); alert(sdfgsfgs);}
	}
	
	/* now paint the things in the buffer */
	for (var i = renderQueue.length - 1; i >= 0; i--) {
		if (renderQueue[i]) {
			for (var j = 0; j < renderQueue[i].length; j++) {
				renderQueue[i][j]();
			}
		}
	}
}

/* add an item to the queue of objects to be drawn */
/* f = function to call to do the actual painting; z = z position of object */
function enqueue(f, z) {
	var bucket = Math.floor(z * 10);
	if (renderQueue[bucket]) {
		renderQueue[bucket].push(f);
	} else {
		renderQueue[bucket] = [f];
	}
}

function renderFlat(subj, m) {
	var wv = [];
	for (var j = 0; j < subj.v.length; j++) {
		wv[j] = transformVector(subj.v[j], m);
	}

	for (var j = 0; j < subj.p.length; j++) {
		var poly = subj.p[j];
		var v0 = wv[poly[0]]; var v1 = wv[poly[1]]; var v2 = wv[poly[2]];
		/* clip at z=0 */
		if (v0[2] >= 0 && v1[2] >= 0 && v2[2] >= 0) {
			var sv0 = project(v0); var sv1 = project(v1); var sv2 = project(v2);
			
			if (isFrontFacing(sv0,sv1,sv2)) {
				switch (subj.lighting) {
					case LIGHT_LAMBERTIAN:
						enqueueFlatLambertian(v0, v1, v2, transformNormal(subj.n[j], m), subj.colour, sv0, sv1, sv2);
						break;
					case LIGHT_PHONG:
						enqueueFlatPhong(v0, v1, v2, transformNormal(subj.n[j], m), subj.colour, sv0, sv1, sv2);
						break;
					default:
						enqueueFlat(v0, v1, v2, j, subj.colour, sv0, sv1, sv2);
				}
			}
		}
	}
}

function enqueueFlat(v0, v1, v2, j, colour, sv0, sv1, sv2) {
	enqueue(function() {
		ctx.fillStyle = colour(j *8 + 100);
		flatTriangle(sv0[0], sv0[1], sv1[0], sv1[1], sv2[0], sv2[1]);
	}, (v0[2] + v1[2] + v2[2]) / 3);
}

function enqueueFlatLambertian(v0, v1, v2, norm, colour, sv0, sv1, sv2) {
	enqueue(function() {
		var intensity = AMBIENT_LEVEL; /* ambient term */
		/* vert0 = point at centre of poly, used to calculate lighting */
		var vert0 = avgVectors(v0, v1, v2);
		for (var i = 0; i < lights.length; i++) {
			var lv = normalise([lights[i][0] - vert0[0], lights[i][1] - vert0[1], lights[i][2] - vert0[2]]);
			intensity += 300 * Math.max(0, dotProduct(norm, lv));
		}
		if (intensity > 255) { intensity = 255; }
		ctx.fillStyle = colour(intensity);
		flatTriangle(sv0[0], sv0[1], sv1[0], sv1[1], sv2[0], sv2[1]);
	}, (v0[2] + v1[2] + v2[2]) / 3);
}

function enqueueFlatPhong(v0, v1, v2, norm, colour, sv0, sv1, sv2) {
	enqueue(function() {
		var intensity = AMBIENT_LEVEL; /* ambient term */
		/* vert0 = point at centre of poly, used to calculate lighting */
		var vert0 = avgVectors(v0, v1, v2);
		var camv = normalise([-vert0[0], -vert0[1], -vert0[2]]);
		for (var i = 0; i < lights.length; i++) {
			var lv = normalise([lights[i][0] - vert0[0], lights[i][1] - vert0[1], lights[i][2] - vert0[2]]);
			var ndotl = dotProduct(norm, lv);
			intensity += 200 * Math.max(0, ndotl) + 100 * Math.max(0,
				Math.pow((2*ndotl*norm[0] - lv[0]) * camv[0] + (2*ndotl*norm[1] - lv[1]) * camv[1] + (2*ndotl*norm[2] - lv[2]) * camv[2], 20)
			);
		}
		if (intensity > 255) { intensity = 255; }
		ctx.fillStyle = colour(intensity);
		flatTriangle(sv0[0], sv0[1], sv1[0], sv1[1], sv2[0], sv2[1]);
	}, (v0[2] + v1[2] + v2[2]) / 3);
}

function renderGouraud(subj, m) {
	var wv = [];
	var wn = [];
	var lightingFn = (subj.lighting == LIGHT_LAMBERTIAN) ? enqueueGouraudLambertian : enqueueGouraudPhong;
	for (var j = 0; j < subj.v.length; j++) {
		wv[j] = transformVector(subj.v[j], m);
		wn[j] = transformNormal(subj.n[j], m);
	}

	for (var j = 0; j < subj.p.length; j++) {
		var poly = subj.p[j];
		var pv = [wv[poly[0]], wv[poly[1]], wv[poly[2]]];
		/* clip at z=0 */
		if (pv[0][2] >= 0 && pv[1][2] >= 0 && pv[2][2] >= 0) {
			var sv0 = project(pv[0]); var sv1 = project(pv[1]); var sv2 = project(pv[2]);
			if (isFrontFacing(sv0,sv1,sv2)) {
				pn = [wn[poly[0]], wn[poly[1]], wn[poly[2]]];
				lightingFn(pv, pn, subj.colour, sv0, sv1, sv2);
			} else if (subj.altColour) {
				// pn = [wn[poly[0]], wn[poly[1]], wn[poly[2]]];
				pn = [negateVector(wn[poly[0]]), negateVector(wn[poly[1]]), negateVector(wn[poly[2]])];
				lightingFn(pv, pn, subj.altColour, sv0, sv1, sv2);
			}
		}
	}
}
function enqueueGouraudLambertian(vert, normal, colour, sv0, sv1, sv2) {
	enqueue(function() {
		var intensity = [];
		for (k = 0; k < 3; k++) {
			intensity[k] = AMBIENT_LEVEL; /* ambient term */
			for (var i = 0; i < lights.length; i++) {
				var lv = normalise([lights[i][0] - vert[k][0], lights[i][1] - vert[k][1], lights[i][2] - vert[k][2]]);
				var ndotl = dotProduct(normal[k], lv);
				intensity[k] += 300 * Math.max(0, ndotl);
			}
			if (intensity[k] > 255) { intensity[k] = 255; }
		}
		gouraudTriangle(sv0[0], sv0[1], intensity[0], sv1[0], sv1[1], intensity[1], sv2[0], sv2[1], intensity[2], colour);
	}, (vert[0][2] + vert[1][2] + vert[2][2]) / 3);
}

function enqueueGouraudPhong(vert, normal, colour, sv0, sv1, sv2) {
	enqueue(function() {
		var intensity = [];
		for (k = 0; k < 3; k++) {
			intensity[k] = AMBIENT_LEVEL; /* ambient term */
			var camv = normalise([-vert[k][0], -vert[k][1], -vert[k][2]]);
			for (var i = 0; i < lights.length; i++) {
				var lv = normalise([lights[i][0] - vert[k][0], lights[i][1] - vert[k][1], lights[i][2] - vert[k][2]]);
				var ndotl = dotProduct(normal[k], lv);
				intensity[k] += 100 * Math.max(0, ndotl) + 200 * Math.max(0,
					Math.pow((2*ndotl*normal[k][0] - lv[0]) * camv[0] + (2*ndotl*normal[k][1] - lv[1]) * camv[1] + (2*ndotl*normal[k][2] - lv[2]) * camv[2], 20)
				);
			}
			if (intensity[k] > 255) { intensity[k] = 255; }
		}
		gouraudTriangle(sv0[0], sv0[1], intensity[0], sv1[0], sv1[1], intensity[1], sv2[0], sv2[1], intensity[2], colour);
	}, (vert[0][2] + vert[1][2] + vert[2][2]) / 3);
}

function renderSprites(subj, m) {
	for (var j = 0; j < subj.v.length; j++) {
		var wv = transformVector(subj.v[j], m);
		/* clip at z=0 */
		if (wv[2] >= 0) {
			var sv = project(wv);
			if (subj.image) {
				enqueueSprite(subj.image, subj.size, wv, sv);
			} else {
				enqueueBox(wv, sv);
			}
		}
	}
}
function enqueueBox(wv, sv) {
	enqueue(function() {
		drawBox(sv[0], sv[1], 20 /* * FOC / (FOC + wv[2]) */);
	}, wv[2]);
}
function enqueueSprite(img, size, wv, sv) {
	enqueue(function() {
		drawSprite(img, sv[0], sv[1], (1-PERSPECTIVE_ALTERING_MINDFUCK_RATIO) * size / wv[2] + PERSPECTIVE_ALTERING_MINDFUCK_RATIO * size);
	}, wv[2]);
}

function renderMultisprites(subj, m) {
	/* a multisprite entry in the scene graph has:
	v: a list of position vectors, as usual
	images: an array of images in ascending anticlockwise rotation order
	arity: number of times the sequence of images is repeated per rotation
	size: pixel size (in both dimensions - sprite must be square) as it would appear at distance 1
	*/
	for (var j = 0; j < subj.v.length; j++) {
		var wv = transformVector(subj.v[j], m);
		/* clip at z=0 */
		if (wv[2] >= 0) {
			var sv = project(wv);
			if (subj.image) {
				enqueueMultisprite(subj.images, subj.arity, subj.size, wv, sv);
			}
		}
	}
}
function enqueueMultisprite(images, arity, size, wv, sv) {
	enqueue(function() {
		var imgIndex = Math.floor(arity * images.length * Math.atan2(wv[2], wv[0]) / (Math.PI * 2)) % images.length;
		drawSprite(images[imgIndex], sv[0], sv[1], size / wv[2]);
	}, wv[2]);
}

function render(scene, m, t) {
	for (var i = 0; i < scene.subjects.length; i++) {
		var subj = scene.subjects[i];
		if (subj.transform) {
			var new_m = subj.transform(m, t);
			render(subj, new_m, t);
		} else if (subj.light) {
			lights.push(transformVector(subj.light, m));
		} else if (subj.generate) {
			var newSubj = subj.generate(t);
			newSubj.model(newSubj, m);		
		} else {
			subj.model(subj, m);
		}
	}
}

function project(v) {
	var perspect = [
		v[0] * X_PROJ_COEFF / v[2] + PROJECTION_CENTRE_X,
		PROJECTION_CENTRE_Y - v[1] * Y_PROJ_COEFF / v[2]
	];
	if (PERSPECTIVE_ALTERING_MINDFUCK_RATIO == 0) {
		return perspect;
	} else {
		var nonperspect = [
			80 * v[0] + PROJECTION_CENTRE_X,
			PROJECTION_CENTRE_Y - 80 * v[1]
		];
		return [
			PERSPECTIVE_ALTERING_MINDFUCK_RATIO * nonperspect[0] + (1 - PERSPECTIVE_ALTERING_MINDFUCK_RATIO) * perspect[0],
			PERSPECTIVE_ALTERING_MINDFUCK_RATIO * nonperspect[1] + (1 - PERSPECTIVE_ALTERING_MINDFUCK_RATIO) * perspect[1]
		];
	}
}

function isFrontFacing(sv0, sv1, sv2) {
	/* takes three sets of screen coordinates. Must be in anticlockwise order to return true */
	return ((sv1[0] - sv0[0]) * (sv2[1] - sv0[1]) - (sv2[0] - sv0[0]) * (sv1[1] - sv0[1]) < 0);
}

