// poly.js

var polys = 12;

var cosi = new Array(360);
var sini = new Array(360);

var rx = new Array(24);
var ry = new Array(24);
var rz = new Array(24);

var poly_r;
var poly_p;

var count = 0;

var dotX1=0;
var dotY1=0;
var dotZ1=0;

var dotX2=0;
var dotY2=0;
var dotZ2=0;

var dotX3=0;
var dotY3=0;
var dotZ3=0;

var realX=0;
var realY=0;
var realZ=0;

var xangle=0;
var yangle=0;
var zangle=0;

var xcenter = 1;
var ycenter = 0;
var zcenter = 30;

var poly_dim1 = 1;
var poly_dim2 = 1.15;

var polygons = new Array(
			 -poly_dim1, -poly_dim1, -poly_dim2,
			  poly_dim1, -poly_dim1, -poly_dim2,
			  poly_dim1,  poly_dim1, -poly_dim2,

			  poly_dim1,  poly_dim1, -poly_dim2,
			 -poly_dim1,  poly_dim1, -poly_dim2,
			 -poly_dim1, -poly_dim1, -poly_dim2,
			 
			  poly_dim1, -poly_dim1, poly_dim2,
			 -poly_dim1, -poly_dim1, poly_dim2,
			 -poly_dim1,  poly_dim1, poly_dim2,

			 -poly_dim1,  poly_dim1, poly_dim2,
			  poly_dim1,  poly_dim1, poly_dim2,
			  poly_dim1, -poly_dim1, poly_dim2,

			  poly_dim2, -poly_dim1, poly_dim1,
			  poly_dim2,  poly_dim1, poly_dim1,
			  poly_dim2,  poly_dim1,-poly_dim1,

			  poly_dim2,  poly_dim1,-poly_dim1,
			  poly_dim2, -poly_dim1,-poly_dim1,
			  poly_dim2, -poly_dim1, poly_dim1,

			  -poly_dim2, -poly_dim1, poly_dim1,
			  -poly_dim2, -poly_dim1,-poly_dim1,
			  -poly_dim2,  poly_dim1,-poly_dim1,

			  -poly_dim2,  poly_dim1,-poly_dim1,
			  -poly_dim2,  poly_dim1, poly_dim1,
			  -poly_dim2, -poly_dim1, poly_dim1,
			  
			   poly_dim1, -poly_dim2,-poly_dim1,
			  -poly_dim1, -poly_dim2,-poly_dim1,
			  -poly_dim1, -poly_dim2, poly_dim1,

			  -poly_dim1, -poly_dim2, poly_dim1,
			   poly_dim1, -poly_dim2, poly_dim1,
			   poly_dim1, -poly_dim2,-poly_dim1,

			   poly_dim1,  poly_dim2,-poly_dim1,
			   poly_dim1,  poly_dim2, poly_dim1,
			  -poly_dim1,  poly_dim2, poly_dim1,

			  -poly_dim1,  poly_dim2, poly_dim1,
			  -poly_dim1,  poly_dim2,-poly_dim1,
			   poly_dim1,  poly_dim2,-poly_dim1);

// init3d
for(var t=0; t<360; t++)
{
	cosi[t] = Math.cos(t * 3.14 / 180);
	sini[t] = Math.sin(t * 3.14 / 180);
}

// init musta maailma
var poly_mappi = new Array(w*h);

function init_poly(sin_effect)
{
	w = 72;
	h = 72;
	resX = w;
	resY = h;
	
	if(sin_effect) {
		poly_r = 0.15;
		poly_p = 3.0;
	} else {
		poly_r = 0;
		poly_p = 0;
	}
	
	kuvahead = bmp8(w,h);
}

function clean()
{
	var puolet = h/2*w;
	for(var i=0;i<=h/4*w;i++)
	{
		poly_mappi[i] = "%00";
		poly_mappi[puolet-i] = "%00";
		poly_mappi[puolet+i] = "%00";
		poly_mappi[w*h-i] = "%00";
	}
}

function map2Image()
{
	var tmp = "";
	for(var i=0;i<w*h;i+=4)
		tmp+=poly_mappi[i]+poly_mappi[i+1]+poly_mappi[i+2]+poly_mappi[i+3];
	return tmp;
}

function rotationXYZ(xanglex, yangley, zanglez)
{
	dotY2 = dotY1 * cosi[xanglex] - dotZ1 * sini[xanglex]; 
      	dotZ2 = dotY1 * sini[xanglex] + dotZ1 * cosi[xanglex];

	dotZ3 = dotZ2 * cosi[yangley] - dotX1 * sini[yangley]; 
      	dotX2 = dotZ2 * sini[yangley] + dotX1 * cosi[yangley];

	dotX3 = dotX2 * cosi[zanglez] - dotY2 * sini[zanglez];
      	dotY3 = dotY2 * cosi[zanglez] + dotX2 * sini[zanglez];
}

function perspective()
{
	realX = 256 * (dotX3 / (dotZ3 + zcenter)) + xcenter;
	realY = 256 * (dotY3 / (dotZ3 + zcenter)) + ycenter;
	realZ = dotZ3;
}

function drawScanLine(x,y,len,color)
{
	var padx = (Math.sin(y*poly_r)+1)*poly_p;
	var pady = 0,pos;
	
	y = Math.round(y);
	x = Math.round(x+padx);
	
	len++;
	for(var x1=0;x1<len;x1++)
	{
		pady = Math.round((Math.sin((x+x1)*poly_r)+1)*poly_p);
		pos = ( y + h / 2 + pady ) * w + (x + (w / 2)) + x1;
		if(pos>0 && pos<w*h)
		{
			poly_mappi[pos] = color;
		}
	}
}

function fillPolygon(x1,y1,z1,x2,y2,z2,x3,y3,z3,color)
{
	var yy1, yy2, yy3;
	var xx1, xx2, xx3;
	var zz1, zz2, zz3;
	
	yy1 = y1;
	xx1 = x1;
	zz1 = z1;
	
	if (yy1 < y2)
	{
		yy2 = yy1;
		xx2 = xx1;
		zz2 = zz1;
		yy1 = y2;
		xx1 = x2;
		zz1 = z2;
	}
	else
	{
		yy2 = y2;
		xx2 = x2;
		zz2 = z2;
	}
		
	if (yy1 < y3)
	{
		yy3 = yy2;
		xx3 = xx2;
		zz3 = zz2;
		yy2 = yy1;
		xx2 = xx1;
		zz2 = zz1;
		yy1 = y3;
		xx1 = x3;
		zz1 = z3;
	}
	else
	{
		if (yy2 < y3)
		{
			yy3 = yy2;
			xx3 = xx2;
			zz3 = zz2;
			yy2 = y3;
			xx2 = x3;
			zz2 = z3;
		}
		else
		{
			yy3 = y3;
			xx3 = x3;
			zz3 = z3;
		}
	}

	var poly_height1 = yy1-yy2;
	var poly_height2 = yy2-yy3;
	var poly_height3 = yy1-yy3;
	
	var lineLength1 = Math.sqrt( (xx1-xx2)*(xx1-xx2)+(yy1-yy2)*(yy1-yy2) );
	var lineLength2 = Math.sqrt( (xx2-xx3)*(xx2-xx3)+(yy2-yy3)*(yy2-yy3) );
	var lineLength3 = Math.sqrt( (xx1-xx3)*(xx1-xx3)+(yy1-yy3)*(yy1-yy3) );
	
	col = dec2hex[ Math.round( ( (((x3-x1)*(y3-y2) - (x3-x2)*(y3-y1))/30)*2 ))];

	if ( (x3-x1)*(y3-y2) - (x3-x2)*(y3-y1) > 0 )
	{
		for (var p=0; p<poly_height1; p+=1)
		{
			paikka1 = (lineLength1/poly_height1)*p;
			paikka2 = (lineLength3/poly_height3)*p;
			
			lX = Math.round( xx1+(xx2-xx1)*paikka1/lineLength1  );
			rX = Math.round( xx1+(xx3-xx1)*paikka2/lineLength3  );
			
			if (lX != rX)
			{		
				if (lX < rX)
					drawScanLine(lX,yy1-p,rX-lX,col);
				else
					drawScanLine(rX,yy1-p,lX-rX,col);
			}	
		}
		
		for (var pp=0; pp<poly_height2; pp+=1)
		{
			paikka1 = (lineLength2/poly_height2)*pp;
			paikka2 = (lineLength3/poly_height3)*(pp+poly_height1);
		
			lX = Math.round( xx2+(xx3-xx2)*paikka1/lineLength2  );
			rX = Math.round( xx1+(xx3-xx1)*paikka2/lineLength3  );
			
			if (lX != rX)
			{
				if (lX < rX)
					drawScanLine(lX,yy2-pp,rX-lX,col);
				else
					drawScanLine(rX,yy2-pp,lX-rX,col);
			}	
		}
	}
}

function render_poly()
{
	count = 0;
	
	clean();

	xangle+=5;
	if (xangle >= 360)
		xangle=0;

	yangle+=4;
	if (yangle >= 360)
		yangle=0;

	zangle+=0;
	if (zangle >= 360)
		zangle=0;
	
	for (var b=0; b<(polys*3)*3; b+=3)
	{
		dotX1 = polygons[b];
		dotY1 = polygons[b+1];
		dotZ1 = polygons[b+2];
		
		rotationXYZ(xangle, yangle, zangle);
		perspective();
		
		rx[count] = realX;
		ry[count] = realY;
		rz[count] = realZ;
		count++;
	}
	
	for(var i=0; i<polys; i++)
	{
		fillPolygon(rx[i*3],ry[i*3],rz[i*3],rx[(i*3)+1],ry[(i*3)+1],rz[(i*3)+1],rx[(i*3)+2],ry[(i*3)+2],rz[(i*3)+2],100);
	}
	
	return map2Image();
}

