//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float4x4 matViewProjection;
texture glowTexture;


sampler GlowSampler = sampler_state
{
   texture = (glowTexture);
   MIPFILTER = LINEAR;
   MINFILTER = LINEAR;
   MAGFILTER = LINEAR;
};


const float4 samples[4] = {
-1.0,  0.0, 0, 0.20,
 1.0,  0.0, 0, 0.20,
 0.0,  1.0, 0, 0.20,
 0.0, -1.0, 0, 0.20
};

const float4 samples2[4] = {
-1.2,  0.0, 0, 0.20,
 1.2,  0.0, 0, 0.20,
 0.0,  1.2, 0, 0.20,
 0.0, -1.2, 0, 0.20
};

const float4 samples3[4] = {
-1.4,  0.0, 0, 0.20,
 1.4,  0.0, 0, 0.20,
 0.0,  1.4, 0, 0.20,
 0.0, -1.4, 0, 0.20
};



//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 Tex0     : TEXCOORD0;
};



VS_OUTPUT VS_Normal(float4 Position: POSITION, float2 Tex0 : TEXCOORD0)
{
   VS_OUTPUT Output = (VS_OUTPUT) 0;
   
   Output.Position = mul(matViewProjection,Position);
   Output.Tex0 = Tex0;

   return Output;
}



//--------------------------------------------------------------------------------------
// BLUR
// 
//--------------------------------------------------------------------------------------
float4 PS_Blur(float2 Tex0: TEXCOORD0) : COLOR0
{
   float4 col = float4(0,0,0,0);

   for(int i=0;i<4;i++)
      col += samples[i].w*tex2D(GlowSampler, Tex0 +
                                float2(samples[i].x * 1.0f/800.0f,
                                samples[i].x * 1.0f/600.0f));

   return col;
}

float4 PS_Blur2(float2 Tex0: TEXCOORD0) : COLOR0
{
   float4 col = float4(0,0,0,0);

   for(int i=0;i<4;i++)
      col += samples2[i].w*tex2D(GlowSampler, Tex0 +
                                float2(samples2[i].x * 1.0f/800.0f,
                                samples2[i].x * 1.0f/600.0f));

   return col;
}


float4 PS_Blur3(float2 Tex0: TEXCOORD0) : COLOR0
{
   float4 col = float4(0,0,0,0);

   for(int i=0;i<4;i++)
      col += samples3[i].w*tex2D(GlowSampler, Tex0 +
                                float2(samples3[i].x * 1.0f/800.0f,
                                samples3[i].x * 1.0f/600.0f));

   return col;
}



technique RenderScene1
{
    pass P0
    {          
        VertexShader = compile vs_2_0 VS_Normal();
        PixelShader  = compile ps_2_0 PS_Blur();
    }
    pass P1
    {          
        VertexShader = NULL;
        PixelShader  = compile ps_2_0 PS_Blur2();
    }
    pass P2
    {          
        VertexShader = NULL;
        PixelShader  = compile ps_2_0 PS_Blur3();
    }
}

