import java.awt.Polygon;

public class Ship {
	
	private Space knownSpace;
	private double radius;
	
	private double x_pos;
	private double y_pos;
	
	private double x_vel;
	private double y_vel;
	private double a; //vinkel p skipet
	
	private double vel_max;
	private double a_vel;
	double vel_acc;
	
	public boolean k_left;
	public boolean k_up;
	public boolean k_right;
	public boolean k_down;
	public boolean k_fire;
	public int health = 100;
	
	private PlayerInfo plInfoComp;
	
	public String commander;
	private long lastBurstTick;
	
	public int score;
	
	public int getXPos() {
		return (int)x_pos;
	}
	public int getYPos() {
		return (int)y_pos;
	}
	public double getAngle() {
		return a;
	}
	public int getRadius() {
		return (int)radius;
	}
	public Polygon getPolygon() {
		
		int[] x_punkt = new int[3];
		int[] y_punkt = new int[3];
		
		x_punkt[0] = getXPos() + (int)(0.5 * getRadius() * Math.cos(getAngle() + (2 * Math.PI) / 3));
		y_punkt[0] = getYPos() + (int)(0.5 * getRadius() * Math.sin(getAngle() + (2 * Math.PI) / 3));
		
		x_punkt[1] = getXPos() + (int)(getRadius() * Math.cos(getAngle()));
		y_punkt[1] = getYPos() + (int)(getRadius() * Math.sin(getAngle()));
		
		x_punkt[2] = getXPos() + (int)(0.5 * getRadius() * Math.cos(getAngle() - (2 * Math.PI) / 3));
		y_punkt[2] = getYPos() + (int)(0.5 * getRadius() * Math.sin(getAngle() - (2 * Math.PI) / 3));
		
		Polygon p = new Polygon(x_punkt, y_punkt, 3);
		
		return p;
	}
	public void reset() {
		
		x_pos = Math.random() * knownSpace.WIDTH;
		y_pos = Math.random() * knownSpace.HEIGHT;
		
		x_vel = 0;
		y_vel = 0;
		
		health = 100;
		
		a = Math.random() * Math.PI * 2;
		
	}
	public void fire() {
		
		if (System.currentTimeMillis()- lastBurstTick > 500) { lastBurstTick = System.currentTimeMillis(); }
		if (System.currentTimeMillis() - lastBurstTick < 200) {
		knownSpace.kuler.add(new Bullet(knownSpace , this ,this.x_vel  + Math.cos(a) * 10, this.y_vel  + Math.sin(a) * 10, getXPos() + (int)(getRadius() * Math.cos(getAngle())), getYPos() + (int)(getRadius() * Math.sin(getAngle())) , 2));
		}
	}
	private void applyShockwave() {
		double hyp;
		Eksplosjon tmpE;
		
		
		
		for (int h = 0; h < knownSpace.bang.size();  h++) {
			tmpE = (Eksplosjon)knownSpace.bang.get(h);
			//if (tmpE.getShockStrength() > 10) {
			hyp = Math.sqrt(Math.pow(tmpE.getXPos() - getXPos(), 2) + Math.pow(tmpE.getYPos() - getYPos(), 2));
			
			if (hyp < tmpE.getBlastRadius()) {
				y_vel -= ((tmpE.getYPos() - getYPos())/hyp)* tmpE.getShockStrength() * 0.01;
				x_vel -= ((tmpE.getXPos() - getXPos())/hyp)* tmpE.getShockStrength() * 0.01;
			}
			//}
		}
		avoidHighSpeed();
	}
	private void avoidHighSpeed() {
		double hh;
		hh = Math.sqrt(Math.pow(x_vel, 2) + Math.pow(y_vel, 2));
		
		if (hh > vel_max) {
			y_vel = (y_vel / hh) * vel_max;
			x_vel = (x_vel / hh) * vel_max;
		}
	}
	public void move() {
		applyShockwave();
		
		if (k_fire) { fire(); }
		
		if (k_left) { a-= a_vel; }
		if (k_right) { a+= a_vel; }
		
		if (a > Math.PI * 2) { a -= Math.PI * 2; }
		if (a < 0) { a += Math.PI * 2; }
		
		if (k_up) {
			
			double xx;
			double yy;
			double hh;
			
			y_vel = y_vel + Math.sin(a) * vel_acc;
			x_vel = x_vel + Math.cos(a) * vel_acc;
			
			avoidHighSpeed();
			
		}
		
		
		x_pos += x_vel;
		y_pos += y_vel;
		
		if (x_pos > knownSpace.WIDTH) {x_pos -= knownSpace.WIDTH; }
		if (x_pos < 0) {x_pos += knownSpace.WIDTH; }
		if (y_pos > knownSpace.HEIGHT) {y_pos -= knownSpace.HEIGHT; }
		if (y_pos < 0) {y_pos += knownSpace.HEIGHT; }
		
	}
	
	public String toString() {
		return "Skipet styres av " + commander +"\nX: " + x_pos + "\nY: " + y_pos + "\nA: "+ a + "\nR: "+ radius;
	}
	public Ship (Space container, PlayerInfo plInfoComp, String commander, double vel_max, double vel_acc, double a_vel, double radius) {
		knownSpace = container;
		this.vel_max = vel_max;
		this.vel_acc = vel_acc;
		this.a_vel = a_vel;
		this.radius = radius;
		this.commander = commander;
		this.plInfoComp = plInfoComp;
		reset();
	}
	
	public void updatePlayerInfo() {
		plInfoComp.repaint();
	}
}
