import java.awt.*;
import javax.swing.*;

public class PlayerInfo extends JComponent {
	Ship Player;
	
	public PlayerInfo(Space knownSpace) {
		setPreferredSize(new Dimension(400,20));
	}
	
	public void setShipPointer(Ship p) {
		Player = p;
	}
	
	public void paintComponent(Graphics page) {
		Font f = new Font("Verdana", Font.BOLD, 14);
		
		page.setFont(f);
		page.setColor(new Color(0,0,0));
		page.fillRect(0,0, 400, 30);
		
		page.setColor(new Color(100,100,100));
		page.fillRect(297, 3, Player.health, 14);
		
		page.setColor(new Color(255,255,255));
		page.drawRect(297, 3, 100, 14);
		
		page.setColor(new Color(255,255,255));
		page.drawString(Player.commander, 5,14);
		
		page.setColor(new Color(255,255,255));
		page.drawString(Player.score + " poeng", 197, 14);
	}
}
