#include "quad.fx"

////////////////////////////////////////////////////////////////////////

float  weight[8];

struct VS_INPUT
{
	float4 position : POSITION;
	float2 texCoords       : TEXCOORD0;
	float3 diffuse	: COLOR;
};
struct VS_OUTPUT
{
	float4 position : POSITION;
	float4 texCoord0       : TEXCOORD0;
	float3 diffuse	: COLOR;
};

/*float QuadTexOffset = 0.5;
float2 QuadScreenSize : VIEWPORTPIXELSIZE;

VS_OUTPUT ScreenQuadVS(
		float4 Position : POSITION, 
		float2 TexCoord : TEXCOORD0)
{
    VS_OUTPUT output;
    output.position = Position;
    output.diffuse=1;
    
    QuadScreenSize.x=640.0f;
    QuadScreenSize.y=480.0f;
	float2 offset = float2( QuadTexOffset/(QuadScreenSize.x) , QuadTexOffset/(QuadScreenSize.y) );
	//float2 offset=0.0f;
    output.texCoord0.xy=TexCoord.xy+offset;
    output.texCoord0.zw = 1.0f;
    
    return output;
}
*/
texture TexOriginalScene;
texture TexHorizBlur;
texture TexBlurredMipped;

sampler SamplerOriginalScene = sampler_state
{
	Texture   = <TexOriginalScene>;
	MinFilter = Linear;
	MagFilter = Linear;
	AddressU = Clamp;
	AddressV = Clamp;
};
sampler SamplerHorizBlur = sampler_state
{
	Texture   = <TexHorizBlur>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;	
};
sampler SamplerBlurredMipped = sampler_state
{
	Texture   = <TexBlurredMipped>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	//MipFilter = NONE;
	//AddressU = Wrap;
	//AddressV = Wrap;
};

struct PS_INPUT
{
	float4 position : POSITION;
	float4 texCoord0 : TEXCOORD0;
	//float3 diffuse	: COLOR;
};
struct PS_OUTPUT
{
	float4 diffuse	: COLOR;
};

void
gaussianBlurVert_ps(const PS_INPUT i,
					out float4 outCol : COLOR)
{
	float MAPWIDTH=512;
	float MAPHEIGHT=512;
	float scale=1.0;
	float f=1.0;
	float4 col=0;
	col=weight[0]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 1.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -1.0/MAPWIDTH*scale ) ));
	col+=weight[1]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 3.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -3.0/MAPWIDTH*scale ) ));
	col+=weight[2]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 5.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -5.0/MAPWIDTH*scale ) ));
	col+=weight[3]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 7.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -7.0/MAPWIDTH*scale ) ));
	col+=weight[4]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 9.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -9.0/MAPWIDTH*scale ) ));
	col+=weight[5]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 11.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -11.0/MAPWIDTH*scale ) ));
	col+=weight[6]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 13.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -13.0/MAPWIDTH*scale ) ));
	col+=weight[7]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , 15.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 0.0 , -15.0/MAPWIDTH*scale ) ));
		
	outCol=col;
	//outCol.xyz=col.xyz;
	//outCol.w=0;
	//outCol.w=tex2D(SamplerOriginalScene,i.texCoord0).w;
}

void
gaussianBlurHoriz_ps(const PS_INPUT i,
					out float4 outCol : COLOR)
{
	float MAPWIDTH=512;
	float MAPHEIGHT=512;
	float scale=1.0;
	float f=1.0;
	float4 col=0;
	
	//float weight[8] = { 0.6, 0.2, 0.1, 0.05, 0.03, 0.01, 0.006, 0.004 };
	//float3 col=weight[0]*tex2D(SamplerOriginalScene,i.texCoord0);
	col=weight[0]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 1.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -1.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[1]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 3.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -3.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[2]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 5.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -5.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[3]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 7.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -7.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[4]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 9.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -9.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[5]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 11.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -11.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[6]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 13.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -13.0/MAPWIDTH*scale , 0.0 )*f ));
	col+=weight[7]*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 15.0/MAPWIDTH*scale , 0.0 )*f )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -15.0/MAPWIDTH*scale , 0.0 )*f ));

	outCol=col;
//	outCol.xyz=col.xyz;
	//outCol.w=0;
	//outCol.w=tex2D(SamplerOriginalScene,i.texCoord0).w;
}

void
gaussianBlurDiag_ps(const PS_INPUT i,
					out float4 outCol : COLOR)
{
	float MAPWIDTH=512;
	float MAPHEIGHT=512;
	float scale=1.0;
	float f=1.0;
	float3 col=0;
	col=weight[0]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 1.0/MAPWIDTH*scale , 1.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -1.0/MAPWIDTH*scale , -1.0/MAPWIDTH*scale ) ));
	col+=weight[1]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 3.0/MAPWIDTH*scale , 3.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -3.0/MAPWIDTH*scale , -3.0/MAPWIDTH*scale ) ));
	col+=weight[2]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 5/MAPWIDTH*scale , 5.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -5.0/MAPWIDTH*scale , -5.0/MAPWIDTH*scale ) ));
	col+=weight[3]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 7.0/MAPWIDTH*scale , 7.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -7.0/MAPWIDTH*scale , -7.0/MAPWIDTH*scale ) ));
	col+=weight[4]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 9.0/MAPWIDTH*scale , 9.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -9.0/MAPWIDTH*scale , -9.0/MAPWIDTH*scale ) ));
	col+=weight[5]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 11.0/MAPWIDTH*scale , 11.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -11.0/MAPWIDTH*scale , -11.0/MAPWIDTH*scale ) ));
	col+=weight[6]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 13.0/MAPWIDTH*scale , 13.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -13.0/MAPWIDTH*scale , -13.0/MAPWIDTH*scale ) ));
	col+=weight[7]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( 15.0/MAPWIDTH*scale , 15.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( -15.0/MAPWIDTH*scale , -15.0/MAPWIDTH*scale ) ));
	outCol.xyz=col.xyz;
	//outCol.w=0;
	outCol.w=tex2D(SamplerOriginalScene,i.texCoord0).w;
}
void
gaussianBlurDiag2_ps(const PS_INPUT i,
					out float4 outCol : COLOR)
{
	float MAPWIDTH=512;
	float MAPHEIGHT=512;
	float scale=1.0;
	float f=1.0;
	float3 col=0;
	col=weight[0]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -1.0/MAPWIDTH*scale , 1.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 1.0/MAPWIDTH*scale , -1.0/MAPWIDTH*scale ) ));
	col+=weight[1]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -3.0/MAPWIDTH*scale , 3.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 3.0/MAPWIDTH*scale , -3.0/MAPWIDTH*scale ) ));
	col+=weight[2]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -5/MAPWIDTH*scale , 5.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 5.0/MAPWIDTH*scale , -5.0/MAPWIDTH*scale ) ));
	col+=weight[3]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -7.0/MAPWIDTH*scale , 7.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 7.0/MAPWIDTH*scale , -7.0/MAPWIDTH*scale ) ));
	col+=weight[4]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -9.0/MAPWIDTH*scale , 9.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 9.0/MAPWIDTH*scale , -9.0/MAPWIDTH*scale ) ));
	col+=weight[5]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -11.0/MAPWIDTH*scale , 11.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 11.0/MAPWIDTH*scale , -11.0/MAPWIDTH*scale ) ));
	col+=weight[6]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -13.0/MAPWIDTH*scale , 13.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 13.0/MAPWIDTH*scale , -13.0/MAPWIDTH*scale ) ));
	col+=weight[7]*f*
		(tex2D(SamplerOriginalScene,i.texCoord0 + float2( -15.0/MAPWIDTH*scale , 15.0/MAPWIDTH*scale ) )
		+tex2D(SamplerOriginalScene,i.texCoord0 + float2( 15.0/MAPWIDTH*scale , -15.0/MAPWIDTH*scale ) ));
	outCol.xyz=col.xyz;
	outCol.w=tex2D(SamplerOriginalScene,i.texCoord0).w;
}

technique GaussianBlur
{
	pass P0
	{
		VertexShader = compile vs_1_1 ScreenQuadVS();
		PixelShader	 = compile ps_2_0 gaussianBlurHoriz_ps();
		
        ZEnable			=	False;
        ZWriteEnable	=	False;
        
        AlphaBlendEnable = False;
        SrcBlend    = One;
        DestBlend   = One;
 
        Lighting     = False;
        CullMode     = None;
 	}
	pass P1
	{
		VertexShader = compile vs_1_1 ScreenQuadVS();
		PixelShader	 = compile ps_2_0 gaussianBlurVert_ps();
		
        ZEnable			=	False;
        ZWriteEnable	=	False;
        
        AlphaBlendEnable = False;
        SrcBlend    = One;
        DestBlend   = One;
 
        Lighting     = False;
        CullMode     = None;		
	}
}

float boxsize=1.0;

void
boxBlur_ps(const in float2 uv : TEXCOORD0,
			out float4 outCol : COLOR)
{
	float MAPWIDTH=256;
	float MAPHEIGHT=256;
	float f=boxsize;
	float4 col=0;

	// kernel:
	// a b a
	// b c a
	// a b a
	//
	// a=1/16
	// b=1/8
	// c=1/4

	col=0;
	col+=0.25*tex2D(SamplerOriginalScene,uv);
	col+=0.125*tex2D(SamplerOriginalScene,uv + float2( 1.0/MAPWIDTH,0.0 )*f);
	col+=0.125*tex2D(SamplerOriginalScene,uv + float2( -1.0/MAPWIDTH,0.0 )*f);
	col+=0.125*tex2D(SamplerOriginalScene,uv + float2( 0.0,1.0/MAPWIDTH )*f);
	col+=0.125*tex2D(SamplerOriginalScene,uv + float2( 0.0,-1.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,uv + float2( 1.0/MAPWIDTH,1.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,uv + float2( -1.0/MAPWIDTH,-1.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,uv + float2( 1.0/MAPWIDTH,-1.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,uv + float2( -1.0/MAPWIDTH,1.0/MAPWIDTH )*f);

//
// a   a
//  b b 
//   c
//  b b
// a   a
//
//
/*
	col+=0.125*tex2D(SamplerOriginalScene,i.texCoord0 + float2( 1.0/MAPWIDTH,1.0/MAPWIDTH )*f);
	col+=0.125*tex2D(SamplerOriginalScene,i.texCoord0 + float2( -1.0/MAPWIDTH,-1.0/MAPWIDTH )*f);
	col+=0.125*tex2D(SamplerOriginalScene,i.texCoord0 + float2( 1.0/MAPWIDTH,-1.0/MAPWIDTH )*f);
	col+=0.125*tex2D(SamplerOriginalScene,i.texCoord0 + float2( -1.0/MAPWIDTH,1.0/MAPWIDTH )*f);
	
	col+=0.0625*tex2D(SamplerOriginalScene,i.texCoord0 + float2( 2.0/MAPWIDTH,2.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,i.texCoord0 + float2( -2.0/MAPWIDTH,-2.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,i.texCoord0 + float2( 2.0/MAPWIDTH,-2.0/MAPWIDTH )*f);
	col+=0.0625*tex2D(SamplerOriginalScene,i.texCoord0 + float2( -2.0/MAPWIDTH,2.0/MAPWIDTH )*f);
*/

	outCol=col;
}		

technique BoxBlur
{
	pass P0
	{
		VertexShader = compile vs_1_1 ScreenQuadVS();
		PixelShader	 = compile ps_2_0 boxBlur_ps();
		
        ZEnable			=	False;
        ZWriteEnable	=	False;
        AlphaBlendEnable = False;
        Lighting     = False;
        CullMode     = None;
	}
}
///////////////////////////////////////////////////////////////////////////////////////////
