#include "quad.fx"

texture TexCopyTexture : Texture;

sampler SamplerCopyTexture = sampler_state
{
	Texture   = <TexCopyTexture>;
	//MinFilter = LINEAR;
	//MagFilter = LINEAR;
	//MipFilter = NONE;
	//AddressU = Wrap;
	//AddressV = Wrap;
};

texture Texture;

sampler SamplerBase = sampler_state
{
	Texture   = <Texture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;
};

float alpha=1.0;

float4
ps_debug_copytexture(const in float2 uv : TEXCOORD0) : COLOR
{
	return tex2D(SamplerBase,uv)*alpha;
}

technique Flash
{
	pass P0
	{
        vertexshader = compile vs_1_1 ScreenQuadVS();
        pixelshader  = compile ps_2_0 ps_debug_copytexture();

        ZEnable			=	False;
        ZWriteEnable	=	False;
        AlphaBlendEnable = False;
        Lighting     = False;
        CullMode     = None;	
	}
}
