
float4
averageColors(float4 base,float4 blend)
{
    return (blend+base)/2;
}
float4
addColors(float4 base,float4 blend)
{
    return (base+blend);
}
float4
subtractColors(float4 base,float4 blend)
{
	return base+blend-1;
    return (base-blend);
}
float4
darkenColors(float4 base,float4 blend)
{
    return min(base,blend);
}
float4
lightenColors(float4 base,float4 blend)
{
    return max(base,blend);
}
float4
multiplyColors(float4 base,float4 blend)
{
    return base*blend;
}
float4
differenceColors(float4 base,float4 blend)
{
    return abs(base-blend);
}
float4
inverseDifferenceColors(float4 base,float4 blend)
{
    return 1-abs(1-base-blend);
}
float4
exclusionColors(float4 base,float4 blend)
{
    return base + blend - (2*base*blend);
	//return averageColors( differenceColors(base,blend) , inverseDifferenceColors(base,blend) );    
}
float4
screenColors(float4 base,float4 blend)
{
    return 1 - (1 - base) * (1 - blend);
}
float4
burnColors(float4 base,float4 blend)
{
    return 1-(1-base)/blend;
}
float4
burnSquaredColors(float4 base,float4 blend)
{
    return 1-((1-base)*(1-base))/blend;
}
float4
dodgeColors(float4 base,float4 blend)
{
    return base / (1-blend);
}
float4
dodgeSquaredColors(float4 base,float4 blend)
{
    return (base*base) / (1-blend);
}
float4
overlayColors(float4 base,float4 blend)
{
    float4 lumCoeff = float4(0.25,0.65,0.1,0);
    float L = min(1,max(0,10*(dot(lumCoeff,base)- 0.45)));
    float4 result1 = 2 * base * blend;
    float4 result2 = 1 - 2*(1-blend)*(1-base);
    return lerp(result1,result2,L);
}
float4
softlightColors(float4 base,float4 blend)
{
    return 2*base*blend + base*base - 2*base*base*blend;
}
float4
hardlightColors(float4 base,float4 blend)
{
    float4 lumCoeff = float4(0.25,0.65,0.1,0);
    float L = min(1,max(0,10*(dot(lumCoeff,blend)- 0.45)));
    float4 result1 = 2 * base * blend;
    float4 result2 = 1 - 2*(1-blend)*(1-base);
    return lerp(result1,result2,L);
}
