
System.usbDiskModeActivate()
green = Color.new(0, 255, 0)
time = 0
pi = math.atan(1) * 4

-- constants defined here
SCREEN_WIDTH = 480
SCREEN_HEIGHT = 272
WMAP_WIDTH = 20 -- actual PSP width/2 as each block is 2x2
WMAP_HEIGHT = 20 -- actual PSP height/2 as each block is 2x2

-- global vars here
watermap = {} -- our (hopefully) gorgeous fire array
watermap2 = {}
count = 0

colors = {}
black = Color.new(0,0,0);
blue = Color.new(0,0,255);

-- some colors to play with
color = { 
	red = Color.new(255,0,0);
	green = Color.new(0, 255, 0);
	blue = Color.new(0,0,255);
	white = Color.new(255,255,255);
	black = Color.new(0,0,0);
	white = Color.new(255,255,255);
}

-- function:     water_init
-- params: none
-- returns: void
--
-- sets up the water arrays, zeros the array
--
function water_init ()
for h=0,WMAP_HEIGHT do
watermap[h] = {} -- new row
watermap2[h] = {}
for w=0,WMAP_WIDTH do
watermap[h][w] = 0 -- reset
watermap2[h][w] = 0
end -- for w loop
end -- for h loop
end -- function fire_init

-- function:     water_tick
-- params: none
-- returns: void
--
-- goes through watermap and updates cells based on
-- water algo.
--
function water_tick ()
sum = 0
for h=1,WMAP_HEIGHT-1 do
 for w=1,WMAP_WIDTH-1 do
  -- go through cells and update
  sum = watermap[h][w-1] + watermap[h-1][w] + watermap[h][w+1] + watermap[h+1][w]
  sum = sum / 2
  sum = sum - watermap2[h][w]
  sum = sum - (sum / 4)
  sum = math.ceil(sum)
  watermap2[h][w] = sum
 end -- for w
end -- for h

for h=1,WMAP_HEIGHT-1 do
for w=1,WMAP_WIDTH-1 do
 temp = watermap[h][w]
 watermap[h][w] = watermap2[h][w]
 watermap2[h][w] = temp
end -- for w loop
end -- for h loop

end -- function water_tick

function water_render ()
col = 0
for h=0,WMAP_HEIGHT-1 do
for w=0,WMAP_WIDTH-1 do
col = watermap[h][w]
screen:fillRect(w*4,h*4,4,4,watercolors[col])
end -- for w loop
end -- for h loop
end -- function water_render


watercolors = {}

-- init
for i=-256,256 do
watercolors[i] = Color.new((i+256)/2,(i+256)/2,256);
end

-- global vars here
watermap = {} -- our (hopefully) gorgeous fire array
watermap2 = {}
count = 0

black = Color.new(0,0,0);
blue = Color.new(0,0,255);

--music global vars
iCurrentSong=0
bButtonPressed = 0
iMusicVolume=254
MAXSONGS=13
MAXEFFECTS=13	--the last song is duplicated for PG's tribute.

--lonnie's things
LONNIE=5
LONNIETEXT=9

Music.volume(iMusicVolume)

pad = Controls.read()

--dpnut gglobal vars
--bounce donut
    x = 1;
    dx=1;
    y=50;
    dy=10;
    ddy=-1;

donut1 = Image.load("flameDonut01.png")
donut2 = Image.load("flameDonut02.png")
donut3 = Image.load("flameDonut03.png")


--fire global vars

-- constants defined here
FMAP_WIDTH =  40  -- 
FMAP_HEIGHT = 30  -- 

-- constants for fire values
RED     = 1
ORANGE  = 2
YELLOW  = 3
NOFIRE  = 0
MAX_COLORS = 255;

-- cnostant for scroller
-- also donuts
DONUTFRAMES = 3
CHARS = 10

scrolltext={}
scrolltextLen={}
scrolltext[0] = [[Northern Dragons present: gigertron, a music disk for the psp. Why play mp3s when you can play tracked music? Hit -> to start the tunes.  ]]
scrolltext[1] = [[this is the second ver! can you hear the difference? ]]
scrolltext[2] = [[Bernielomax typing. This track was written in an extremely short amount of time. The idea here was to do a very generic composition with a catchy riff. Lots of trance cliches here. Some times easy is golden. Greets goes to the soulseek crew, the gbs-tv crew, all my friends and thank you for listening. ]]
scrolltext[3] = [[Hi, bernielomax on the keys. Combining softsynth madness and tracking can be fun. I got a lot of input while doing this song on what kind of wild ideas might work. A lot of energy is waiting to be released. Greets goes to the soulseek crew, the gbs-tv crew, all my friends around me and thank you for listening. ]]
scrolltext[4] = [[over thruster actually made 2 vers of this song. ]]
scrolltext[5] = [[This song marked a new style for me. The highly introspective style where what you might just believe you heard actually might be true. Greets goes to the soulseek crew, the gbs-tv crew, all my friends and thank you for listening. ]]
scrolltext[6] = [[This track is all about the space and a forgotten spaceship, dead crew, but with the machinery still operating. An experiment in tension and release. This song has earlier been released in a remixed version of the  Greets goes to the soulseek crew, the gbs-tv crew, all my friends and thank you for listening.]]
scrolltext[7] = [[Hardliner wrote this song, called pungent house. I really like it. He's a cool guy.]]
scrolltext[8] = [[this is the last song, it's called c64... overthruster wrote it. ]]
scrolltext[9] = [[soul d's song. guybrush->this song is bigger than the rest of the music disk!!!<-guybrush]]

scrolltext[10]=[[dragorn by k9d, trakk hakkin for the northern dragons in two thousand and five! greetz: random, peppermints, doctorow, salkin, johan (and the lsdj list), nully, stoney, nohj + everyone else on efnet ... #mp3noise, slash slash, 8bitpeoples, gp32 scene, slsk artists]]
scrolltext[11]=[[MADe bY iGNAT in One scary NigHt after reading the last chapters of  A TRIP TO ARCTURUS by David Lindsay     Some presences surround me, this last days of unhappy feeling, the pills give me nightmares and nothing in life taste like it should. Tastes and colors are right but nothing can bring back some emotion to my life.     Thanks to my beloved Marisol for being all for me (even when I'm a dead body), Jordan and Jeremy for being cool as ever, Tolga, Jon Bro, Sascha, Pavlo Vertical (coleco music), Ruben for the help me with the visuals in my gig at Flash PArty, Ariel (technical advantage an support), Jose Torres for providing me web space and being cool. Greetz to Kenny, Matias and Fear (FP).]]
scrolltext[12]=[[nullsleep's greets go here]]--reserved for nullsleep
scrolltext[13]=[[nullsleep made 2 songs? this would be the 2nd]]--reserved for nullsleep also??

scrolltext[MAXSONGS]=[[| guybrush -> Hey Pat groove! We hid a little message to you in the music disk. Sad to see you go, you'll be missed.<-guybrush | syntax->the uber artist of the dragons, the only member (possibly) to take part in a meeting while drunk - the scene is a little bit smaller due to your leaving. good luck with whatever life throws at you.<-syntax | polaris-> To Pat G...  Bran Muffins!  Yeah, that's right - keep fiber in your diet.  None of this iron chef stuff if you decide to teach English in Japan! Muffins damit! Wishing you all the best in your future non-scene related activities.<-polaris | barzoule->< barzoule- | blacklight -><- blacklight]]


for i=0,MAXSONGS do
	scrolltextLen[i]=string.len(scrolltext[i])
end

--scrolltextLen = string.len(scrolltextintro)
--scrolltext1Len = string.len(scrolltextintro)

screenchars={}
-- global vars here
firemap = {}       -- our (hopefully) gorgeous fire array
firemap2 = {}

colors = {}
black = Color.new(0,0,0);
green = Color.new(0,255,0);
blue = Color.new(0,0,255);

heatmap = {2.65,3.1,3.62,2.97,3.5,2.4,2.82,3.21,2.74,3.83}
heatmapidx = 1

--end fire global vars
--start fire functions

-- function:	  fire_init
-- params:          none
-- returns:         void
--
-- sets up the fire array, zeros the array
--
function fire_init ()

-- init
colors[0] = Color.new(0,0,0)
for i=0,85 do
   colors[85-i] = Color.new(255-(i*3),0,0)     -- red
end
for i=0,85 do
   colors[170-i] = Color.new(255,255-(i*3),0)     --orange
end
for i=0,85 do
   colors[255-i] = Color.new(255,255,255-(i*3))     --yellow
end
	
    for h=0,FMAP_HEIGHT do
        firemap[h] = {}        -- new row
        firemap2[h] = {}
        for w=0,FMAP_WIDTH do
            firemap[h][w] = NOFIRE  -- reset
            firemap2[h][w] = NOFIRE
        end -- for w loop
    end -- for h loop

    -- setup the bottom row
    for w=0,FMAP_WIDTH-1 do
        firemap[FMAP_HEIGHT-1][w] = math.mod(w,MAX_COLORS-5)+5--math.random(MAX_COLORS-5) + 5
    end -- for w
end -- function fire_init

-- function:	  fire_tick
-- params:          none
-- returns:         void
--
-- goes through firemap and updates cells based on
-- fire algo.
--
function fire_tick ()
    sum = 0
    for h=1,FMAP_HEIGHT-2 do
        for w=1,FMAP_WIDTH-1 do
            -- go through cells and update
            sum = firemap[h][w-1] + firemap[h-1][w] + firemap[h][w+1] + firemap[h+1][w]
            sum = sum / 4
            --print(tostring(h),tostring(w),tostring(sum1),tostring(sum2),tostring(sum3))
            -- sum = sum - ((math.random(5) / 10) + 2)
            sum = sum -2*heatmap[heatmapidx]
            heatmapidx = heatmapidx + 1
            if heatmapidx > 10 then
                heatmapidx = 1
            end
            if sum < 0 then
                sum = 1
            end
            -- sum = math.ceil(sum / 8)
            sum = math.ceil(sum)
            firemap2[h-1][w] = sum
        end -- for w
    end -- for h

    for w=0,FMAP_WIDTH-1 do
        firemap2[FMAP_HEIGHT-2][w] = firemap[FMAP_HEIGHT-1][w]
    end -- for w


    for h=1,FMAP_HEIGHT-1 do
      for w=1,FMAP_WIDTH-1 do
          firemap[h][w] = firemap2[h][w]
      end -- for w loop
    end -- for h loop

    -- setup the bottom row
    for w=0,FMAP_WIDTH-1 do
        firemap[FMAP_HEIGHT-1][w] = math.random(MAX_COLORS-5) + 5
    end -- for w
end -- function fire_tick

function fire_render ()
    col = 0
    pixSize=5;
    for h=1,FMAP_HEIGHT-4 do
        for w=1,FMAP_WIDTH-1 do
		
            col = firemap[h][w]
	    if col > 10 then
               --print(tostring(h),tostring(w),tostring(col))
               theScene:fillRect(pixSize+w*pixSize,110+h*pixSize,pixSize,pixSize,colors[col])
	       --theScene:pixel(w,h,colors[col])
            end
        end -- for w loop
    end -- for h loop
end -- function fire_render

--end fire functions

-- constants for fire values



-- create a scene
theScene = Image.createEmpty(480, 272)

--focal length to determine perspective scaling
focalLength = 125

-- here we set up a function to make an object with 
-- x, y and z properties to represent a 3D point.  
make3DPoint = function(x,y,z)
	local point = {}
	point.x = x
	point.y = y
	point.z = z
	return point
	end

-- similarly set up a function to make an object with 
-- x and y properties to represent a 2D point.
make2DPoint = function(x, y)
	local point = {}
	point.x = x+240
	point.y = y+131
	return point
	end

-- conversion function for changing an array of 3D points to an
-- array of 2D points which is to be returned.
Transform3DPointsTo2DPoints = function(points, axisRotations)
	-- the array to hold transformed 2D points - the 3D points
	-- from the point array which are here rotated and scaled
	--to generate a point as it would appear on the screen
	local TransformedPointsArray = {}
	-- Math calcs for angles - sin and cos for each (trig)
	-- this will be the only time sin or cos is used for the
	-- entire portion of calculating all rotations
	local sx = math.sin(axisRotations.x)
	local cx = math.cos(axisRotations.x)
	local sy = math.sin(axisRotations.y)
	local cy = math.cos(axisRotations.y)
	local sz = math.sin(axisRotations.z)
	local cz = math.cos(axisRotations.z)
	
	-- a couple of variables to be used in the looping
	-- of all the points in the transform process
	local x,y,z, xy,xz, yx,yz, zx,zy, scaleRatio

	-- loop through all the points in your object/scene/space
	-- whatever - those points passed - so each is transformed
	local i = table.getn(points)
	while (i >0) do
		--apply Math to making transformations
		-- based on rotations
		-- assign variables for the current x, y and z
		x = points[i].x
		y = points[i].y
		z = points[i].z

		-- perform the rotations around each axis
		-- rotation around x
		xy = cx*y - sx*z
		xz = sx*y + cx*z
		-- rotation around y
		yz = cy*xz - sy*x
		yx = sy*xz + cy*x
		-- rotation around z
		zx = cz*yx - sz*xy
		zy = sz*yx + cz*xy

		-- now determine perspective scaling factor
		-- yz was the last calculated z value so its the
		-- final value for z depth
		scaleRatio = focalLength/(focalLength + yz)
		-- assign the new x and y
		x = zx*scaleRatio
		y = zy*scaleRatio
		-- create transformed 2D point with the calculated values
		-- adding it to the array holding all 2D points
		TransformedPointsArray[i] = make2DPoint(x, y)
	i = i -1
	end
	-- after looping return the array of points as they
	-- exist after the rotation and scaling
	return TransformedPointsArray
end

-- pyramid
pointsArray = {
make3DPoint(0,-50,0),
make3DPoint(0,-50,0),
make3DPoint(0,-50,0),
make3DPoint(0,-50,0),
make3DPoint(-50,50,-50),
make3DPoint(50,50,-50),
make3DPoint(50,50,50),
make3DPoint(-50,50,50),
}

-- an object to represent the 3 angles of rotation
cubeAxisRotations = make3DPoint(0,0,0)

rotateCube = function()
	cubeAxisRotations.y = cubeAxisRotations.y + userY
	cubeAxisRotations.x = cubeAxisRotations.x + userX
	-- create a new array to contain the 2D x and y positions of the
	-- points in the pointsArray as they would exist on the screen
	local screenPoints = Transform3DPointsTo2DPoints(pointsArray, cubeAxisRotations)
	-- clear the scene
--	theScene:fillRect(0, 0 , 480, 272, color.black)
	-- draw the lines needed to make the square
	-- top
	theScene:drawLine(screenPoints[1].x, screenPoints[1].y, screenPoints[2].x, screenPoints[2].y, color.green)
	theScene:drawLine(screenPoints[2].x, screenPoints[2].y, screenPoints[3].x, screenPoints[3].y, color.green)
	theScene:drawLine(screenPoints[3].x, screenPoints[3].y, screenPoints[4].x, screenPoints[4].y, color.green)
	theScene:drawLine(screenPoints[4].x, screenPoints[4].y, screenPoints[1].x, screenPoints[1].y, color.green)
	-- bottom
	theScene:drawLine(screenPoints[5].x, screenPoints[5].y, screenPoints[6].x, screenPoints[6].y, color.green)
	theScene:drawLine(screenPoints[6].x, screenPoints[6].y, screenPoints[7].x, screenPoints[7].y, color.green)
	theScene:drawLine(screenPoints[7].x, screenPoints[7].y, screenPoints[8].x, screenPoints[8].y, color.green)
	theScene:drawLine(screenPoints[8].x, screenPoints[8].y, screenPoints[5].x, screenPoints[5].y, color.green)
	-- connecting bottom and top
	theScene:drawLine(screenPoints[1].x, screenPoints[1].y, screenPoints[5].x, screenPoints[5].y, color.green)
	theScene:drawLine(screenPoints[2].x, screenPoints[2].y, screenPoints[6].x, screenPoints[6].y, color.green)
	theScene:drawLine(screenPoints[3].x, screenPoints[3].y, screenPoints[7].x, screenPoints[7].y, color.green)
	theScene:drawLine(screenPoints[4].x, screenPoints[4].y, screenPoints[8].x, screenPoints[8].y, color.green)
end



-- keyboard control
function keyboardControl()
	local pad = Controls.read()
	if pad:select() then
            screen:save("screenshot.tga")
	end
	-- going left
	if pad:analogX() < -30 or pad:left() then
		if  userY > -0.2 then 
			userY = userY  -.01
		end
	-- going right
        elseif pad:analogX() > 30 or pad:right() then
		if userY < 0.2 then
		        userY = userY  + .01	
                end
	end 
	-- going down
	if pad:analogY() < -30 or pad:down() then
		if  userX > -0.2 then 
			userX = userX  -.01
		end
	-- going up
        elseif pad:analogY() > 30 or pad:up() then
		if userX < 0.2 then
		        userX = userX  + .01	
                end
	end
	

	--music disk input
	--debounce song switches
	if(bButtonPressed==1)then
		if not (pad:up() or pad:down() or pad:left() or pad:right()) then
			        --change song if button pressed
                if bButtonPressed then
                    if(iCurrentSong == 1)then
                        Music.playFile("BMAX_modrn2.IT", true)
                    elseif(iCurrentSong == 2)then
                        Music.playFile("OVERTHRUSTERR_ND_hard_techno.xm", true)
                    elseif(iCurrentSong == 3)then
                        Music.playFile("BMAX_former.IT", true)
                    elseif(iCurrentSong == 4)then
                        Music.playFile("OVERTHRUSTER_xmxmndragon.xm", true)
                    elseif(iCurrentSong == 5)then
                        Music.playFile("BMAX_songfuru.IT", true)
                    elseif(iCurrentSong == 6)then
                        Music.playFile("BMAX_stor.IT", true)
                    elseif(iCurrentSong == 7)then
                        Music.playFile("HARDLINER_pungent_house.xm", true)
                    elseif(iCurrentSong == 8)then
                        Music.playFile("OVERTHRUSTER_nordragc64.it", true)
                    elseif(iCurrentSong == 9)then
                        Music.playFile("Soul_D_Skyline.IT", true)
                    elseif(iCurrentSong == 10)then
                        Music.playFile("K9D_dragorn.xm", true)
                    elseif(iCurrentSong == 11)then
                        Music.playFile("IGNATZ_influenza.it", true)
                    elseif(iCurrentSong == 12)then
                        Music.playFile("OVERTHRUSTER_nordragc64.it", true)
                    elseif(iCurrentSong == 13)then
                        Music.playFile("OVERTHRUSTER_nordragc64.it", true)
                end    
            end
		bButtonPressed=0--debounce once we're back to centre	
		end		
	end
	
	if(bButtonPressed==0)then
            if pad:right() then
                iCurrentSong = iCurrentSong + 1
		iCurrentEffect = iCurrentEffect + 1
                bButtonPressed=1
            end
	    if pad:left() and iCurrentSong > 0 then
		iCurrentSong = iCurrentSong - 1
		iCurrentEffect = iCurrentEffect - 1
		bButtonPressed=1
	    end
       
            if iCurrentSong < 0 then iCurrentSong=1 end
            if iCurrentSong > MAXSONGS then iCurrentSong=MAXSONGS end
	    
            if iCurrentEffect < 0 then iCurrentEffect=1 end
            if iCurrentEffect > MAXEFFECTS then iCurrentEffect=MAXEFFECTS end
        end
        
	--raise/lower volume, no need to debounce
	if(pad:up())then
		iMusicVolume=iMusicVolume+5
	end
	if(pad:down())then
		iMusicVolume=iMusicVolume-5
	end
	if iMusicVolume < 1 then iMusicVolume=1 end
	if iMusicVolume > 255 then iMusicVolume=255 end
	
end
--ND head code

-- ************************************** ND LOGO CODE STARTS **************************************
-- the points array contains all the points in the 3D
-- scene.  These 8 make a square on the screen.
LOGOpointsArray = {
	make3DPoint(-23.125,	-18.125,	0),		--1 Start of head
	make3DPoint(-25,	-10.41666667,	0),		--2
	make3DPoint(-21.875,	8.75,		0),		--3
	make3DPoint(-20.625,	13.125,		0),		--4
	make3DPoint(-11.875,	12.91666667,	0),		--5
	make3DPoint(-6.5625,	10.83333333,	0),		--6
	make3DPoint(5.3125,	13.75,		0),		--7
	make3DPoint(9.84375,	14.16666667,	0),		--8
	make3DPoint(11.71875,	16.04166667,	0),		--9
	make3DPoint(13.28125,	21.66666667,	0),		--10
	make3DPoint(4.53125,	42.5,		0),		--11
	make3DPoint(27.8125,	42.5,		0),		--12
	make3DPoint(27.96875,	35.20833333,	0),		--13
	make3DPoint(30,		34.79166667,	0),		--14
	make3DPoint(29.6875,	28.95833333,	0),		--15
	make3DPoint(28.28125,	26.66666667,	0),		--16
	make3DPoint(30.3125,	25.625,		0),		--17
	make3DPoint(30.46875,	21.45833333,	0),		--18
	make3DPoint(29.0625,	20,		0),		--19
	make3DPoint(28.28125,	15.625,		0),		--20
	make3DPoint(29.6875,	13.125,		0),		--21
	make3DPoint(32.34375,	15.625,		0),		--22
	make3DPoint(29.53125,	8.333333333,	0),		--23
	make3DPoint(31.71875,	8.958333333,	0),		--24
	make3DPoint(32.65625,	8.125,		0),		--25
	make3DPoint(30.46875,	5,		0),		--26
	make3DPoint(32.03125,	1.875,		0),		--27
	make3DPoint(33.4375,	-32.29166667,	0),		--28
	make3DPoint(25.9375,	-31.875,	0),		--29
	make3DPoint(26.09375,	-36.25,		0),		--30
	make3DPoint(30.46875,	-39.79166667,	0),		--31
	make3DPoint(26.25,	-41.04166667,	0),		--32
	make3DPoint(11.5625,	-33.75,		0),		--33
	make3DPoint(7.65625,	-28.125,	0),		--34
	make3DPoint(3.90625,	-26.875,	0),		--35
	make3DPoint(1.25,	-27.91666667,	0),		--36
	make3DPoint(5.46875,	-36.04166667,	0),		--37
	make3DPoint(-1.5625,	-32.08333333,	0),		--38
	make3DPoint(-12.8125,	-15.41666667,	0),		--39
	make3DPoint(-12.96875,	-12.29166667,	0),		--40
	make3DPoint(-17.5,	-13.33333333,	0),		--41
	make3DPoint(-17.5,	-9.375,		0),		--42
	make3DPoint(-19.375,	-8.75,		0),		--43
	make3DPoint(-20.625,	-8.958333333,	0),		--44
	make3DPoint(-23.125,	-18.125,	0),		--45 end of head (loop)
	
	make3DPoint(6.71875,	-18.125,	0),		--46 (EYE)
	make3DPoint(2.1875,	-16.45833333,	0),		--47
	make3DPoint(2.96875,	-12.91666667,	0),		--48
	make3DPoint(6.71875,	-18.125,	0),		--49
}

logoAxisRotations = make3DPoint(0,0,0)
function doNDLOGO()

	logoAxisRotations.y = logoAxisRotations.y + userY
	logoAxisRotations.x = logoAxisRotations.x + userX

	-- create a new array to contain the 2D x and y positions of the
	-- points in the pointsArray as they would exist on the screen
	local screenPoints = Transform3DPointsTo2DPoints(LOGOpointsArray, logoAxisRotations)

	-- clockwize from the noze

	-- not unrolled, so that we can unroll it in the 2nd ver and "find" a perf increase 
	for i=1,44 do
		theScene:drawLine(screenPoints[i].x, screenPoints[i].y, screenPoints[i+1].x, screenPoints[i+1].y, color.green)
	end 

	for i=46,48 do
		theScene:drawLine(screenPoints[i].x, screenPoints[i].y, screenPoints[i+1].x, screenPoints[i+1].y, color.green)
	end 
end

function doNDCube()

	logoAxisRotations.y = logoAxisRotations.y + userY
	logoAxisRotations.x = 0

	-- create a new array to contain the 2D x and y positions of the
	-- points in the pointsArray as they would exist on the screen
	local screenPoints = Transform3DPointsTo2DPoints(LOGOpointsArray, logoAxisRotations)

	-- clockwize from the noze

	-- later we can un-roll this for extra :$ performance if required... but for now: 
	-- the head
	for i=1,44 do
		theScene:drawLine(screenPoints[i].x, screenPoints[i].y, screenPoints[i+1].x, screenPoints[i+1].y, color.green)
	end 

	-- The Eye
	for i=46,48 do
		theScene:drawLine(screenPoints[i].x, screenPoints[i].y, screenPoints[i+1].x, screenPoints[i+1].y, color.green)
	end 

end
 -- end NDCube

--end ND head code

--spikeyball code of doom
spikeypointsArray = {
	make3DPoint(0,0,80),		--1 spikes
	make3DPoint(80,0,0),		--2 s2
	make3DPoint(0,0,-80),		--3 s3
	make3DPoint(-80,0,0),		--4 s4
	make3DPoint(0,40,0),		--5 top
	make3DPoint(0,-40,0),		--6 bottom
	make3DPoint(0,28,28),		--7 U1
	make3DPoint(28,28,0),		--8 U2
	make3DPoint(0,28,-28),		--9 U3
	make3DPoint(-28,28,0),		--10 U4
	make3DPoint(0,0,40),		--11 G1
	make3DPoint(28,0,28),		--12 G2
	make3DPoint(40,0,0),		--13 G3
	make3DPoint(28,0,-28),		--14 G4
	make3DPoint(0,0,-40),		--15 G5
	make3DPoint(-28,0,-28),		--16 G6
	make3DPoint(-40,0,0),		--17 G7
	make3DPoint(-28,0,28),		--18 G8
	make3DPoint(0,-28,28),		--19 D1
	make3DPoint(28,-28,0),		--20 D2
	make3DPoint(0,-28,-28),		--21 D3
	make3DPoint(-28,-28,0),		--22 D4
	make3DPoint(0,80,0),		--23 s5
	make3DPoint(0,-80,0),		--24 s6

}
--end spikeyball

spikeyAxisRotations = make3DPoint(0,0,0)

--we unroll all meshes for performance. 
function drawSpikeyBall()
	spikeyAxisRotations.y = spikeyAxisRotations.y + userY
	spikeyAxisRotations.x = spikeyAxisRotations.x + userX

	-- create a new array to contain the 2D x and y positions of the
	-- points in the pointsArray as they would exist on the screen
	local screenPoints = Transform3DPointsTo2DPoints(spikeypointsArray, spikeyAxisRotations)
--upper circle
	theScene:drawLine(screenPoints[7].x, screenPoints[7].y, screenPoints[8].x, screenPoints[8].y, color.red)
	theScene:drawLine(screenPoints[8].x, screenPoints[8].y, screenPoints[9].x, screenPoints[9].y, color.red)
	theScene:drawLine(screenPoints[9].x, screenPoints[9].y, screenPoints[10].x, screenPoints[10].y, color.red)
	theScene:drawLine(screenPoints[10].x, screenPoints[10].y, screenPoints[7].x, screenPoints[7].y, color.red)
--top pyramid
	theScene:drawLine(screenPoints[5].x, screenPoints[5].y, screenPoints[7].x, screenPoints[7].y, color.red)
	theScene:drawLine(screenPoints[5].x, screenPoints[5].y, screenPoints[8].x, screenPoints[8].y, color.red)
	theScene:drawLine(screenPoints[5].x, screenPoints[5].y, screenPoints[9].x, screenPoints[9].y, color.red)
	theScene:drawLine(screenPoints[5].x, screenPoints[5].y, screenPoints[10].x, screenPoints[10].y, color.red)
--upper interlace
	theScene:drawLine(screenPoints[7].x, screenPoints[7].y, screenPoints[11].x, screenPoints[11].y, color.red)
	theScene:drawLine(screenPoints[7].x, screenPoints[7].y, screenPoints[12].x, screenPoints[12].y, color.red)
	theScene:drawLine(screenPoints[8].x, screenPoints[8].y, screenPoints[12].x, screenPoints[12].y, color.red)
	theScene:drawLine(screenPoints[8].x, screenPoints[8].y, screenPoints[13].x, screenPoints[13].y, color.red)
	theScene:drawLine(screenPoints[8].x, screenPoints[8].y, screenPoints[14].x, screenPoints[14].y, color.red)
	theScene:drawLine(screenPoints[9].x, screenPoints[9].y, screenPoints[14].x, screenPoints[14].y, color.red)
	theScene:drawLine(screenPoints[9].x, screenPoints[9].y, screenPoints[15].x, screenPoints[15].y, color.red)
	theScene:drawLine(screenPoints[9].x, screenPoints[9].y, screenPoints[16].x, screenPoints[16].y, color.red)
	theScene:drawLine(screenPoints[10].x, screenPoints[10].y, screenPoints[16].x, screenPoints[16].y, color.red)
	theScene:drawLine(screenPoints[10].x, screenPoints[10].y, screenPoints[17].x, screenPoints[17].y, color.red)
	theScene:drawLine(screenPoints[10].x, screenPoints[10].y, screenPoints[18].x, screenPoints[18].y, color.red)
	theScene:drawLine(screenPoints[7].x, screenPoints[7].y, screenPoints[18].x, screenPoints[18].y, color.red)
--ground circle
	theScene:drawLine(screenPoints[11].x, screenPoints[11].y, screenPoints[12].x, screenPoints[12].y, color.red)
	theScene:drawLine(screenPoints[12].x, screenPoints[12].y, screenPoints[13].x, screenPoints[13].y, color.red)
	theScene:drawLine(screenPoints[13].x, screenPoints[13].y, screenPoints[14].x, screenPoints[14].y, color.red)
	theScene:drawLine(screenPoints[14].x, screenPoints[14].y, screenPoints[15].x, screenPoints[15].y, color.red)
	theScene:drawLine(screenPoints[15].x, screenPoints[15].y, screenPoints[16].x, screenPoints[16].y, color.red)
	theScene:drawLine(screenPoints[16].x, screenPoints[16].y, screenPoints[17].x, screenPoints[17].y, color.red)
	theScene:drawLine(screenPoints[17].x, screenPoints[17].y, screenPoints[18].x, screenPoints[18].y, color.red)
	theScene:drawLine(screenPoints[18].x, screenPoints[18].y, screenPoints[11].x, screenPoints[11].y, color.red)
--ground-lower interlace
	theScene:drawLine(screenPoints[19].x, screenPoints[19].y, screenPoints[11].x, screenPoints[11].y, color.red)
	theScene:drawLine(screenPoints[19].x, screenPoints[19].y, screenPoints[12].x, screenPoints[12].y, color.red)
	theScene:drawLine(screenPoints[20].x, screenPoints[20].y, screenPoints[12].x, screenPoints[12].y, color.red)
	theScene:drawLine(screenPoints[20].x, screenPoints[20].y, screenPoints[13].x, screenPoints[13].y, color.red)
	theScene:drawLine(screenPoints[20].x, screenPoints[20].y, screenPoints[14].x, screenPoints[14].y, color.red)
	theScene:drawLine(screenPoints[21].x, screenPoints[21].y, screenPoints[14].x, screenPoints[14].y, color.red)
	theScene:drawLine(screenPoints[21].x, screenPoints[21].y, screenPoints[15].x, screenPoints[15].y, color.red)
	theScene:drawLine(screenPoints[21].x, screenPoints[21].y, screenPoints[16].x, screenPoints[16].y, color.red)
	theScene:drawLine(screenPoints[22].x, screenPoints[22].y, screenPoints[16].x, screenPoints[16].y, color.red)
	theScene:drawLine(screenPoints[22].x, screenPoints[22].y, screenPoints[17].x, screenPoints[17].y, color.red)
	theScene:drawLine(screenPoints[22].x, screenPoints[22].y, screenPoints[18].x, screenPoints[18].y, color.red)
	theScene:drawLine(screenPoints[19].x, screenPoints[19].y, screenPoints[18].x, screenPoints[18].y, color.red)
--bottom pyramid
	theScene:drawLine(screenPoints[6].x, screenPoints[6].y, screenPoints[19].x, screenPoints[19].y, color.red)
	theScene:drawLine(screenPoints[6].x, screenPoints[6].y, screenPoints[20].x, screenPoints[20].y, color.red)
	theScene:drawLine(screenPoints[6].x, screenPoints[6].y, screenPoints[21].x, screenPoints[21].y, color.red)
	theScene:drawLine(screenPoints[6].x, screenPoints[6].y, screenPoints[22].x, screenPoints[22].y, color.red)

--bottom circle
	theScene:drawLine(screenPoints[19].x, screenPoints[19].y, screenPoints[20].x, screenPoints[20].y, color.red)
	theScene:drawLine(screenPoints[20].x, screenPoints[20].y, screenPoints[21].x, screenPoints[21].y, color.red)
	theScene:drawLine(screenPoints[21].x, screenPoints[21].y, screenPoints[22].x, screenPoints[22].y, color.red)
	theScene:drawLine(screenPoints[22].x, screenPoints[22].y, screenPoints[19].x, screenPoints[19].y, color.red)

--spikes
	theScene:drawLine(screenPoints[11].x, screenPoints[11].y, screenPoints[1].x, screenPoints[1].y, color.red)
	theScene:drawLine(screenPoints[13].x, screenPoints[13].y, screenPoints[2].x, screenPoints[2].y, color.red)
	theScene:drawLine(screenPoints[15].x, screenPoints[15].y, screenPoints[3].x, screenPoints[3].y, color.red)
	theScene:drawLine(screenPoints[17].x, screenPoints[17].y, screenPoints[4].x, screenPoints[4].y, color.red)
	theScene:drawLine(screenPoints[5].x, screenPoints[5].y, screenPoints[23].x, screenPoints[23].y, color.red)
	theScene:drawLine(screenPoints[6].x, screenPoints[6].y, screenPoints[24].x, screenPoints[24].y, color.red)
end

--intro code
iBlink=0;

function doIntro()
   iBlink = iBlink+1;
   if(iBlink>10)then
           theScene:print(10, 230,"Press -> to start music !! ", color.green)
   end
   if(iBlink>20)then iBlink=0; end
	
	doNDLOGO()
   
end --end intro code

--PatGroove code
patx=0
paty=0
patdx=1
patdy=1

function doPatGroove()
   patx=patx+patdx
   paty=paty+patdy
   if(patx<1)then patdx=1 end
   if(patx>400) then patdx=-1 end
   if paty<1 then patdy=1 end
   if paty>240 then patdy=-1 end

   theScene:blit(patx,paty,patgroove)
end
--end PatGroove code



function doFire()
   fire_tick()
   fire_render()
end

function doCube()
    --for i=1,10 do
    rotateCube()
    --userX=userX+0.001
    --userY=userY+0.001
    --end
    ---userX=userX-0.010
    --userY=userY-0.010
end
flicker = 1;

function doDonut()
	--move donut
	--bounce donut off walls
--bouncey donut!!
 --   x=x+dx;
--    if(x>300)then
--	    dx=-dx
--    end
--    y=y+dy;
--    dy=dy+ddy;
--    if(y<10)then
--	    dy=-dy
--    end
--    --wavey donut is more special
time = time + 1
x=30*math.sin(0.0045*time);
y=20*math.sin(0.0057*time);
-- x = 50;
-- y=50;
    --flicker frames of donut fire
    flicker = flicker + 1;
    if ( flicker > 3)then flicker = 1;end
	    
    if(flicker == 1) then theScene:blit(x,y,donut1)end
    if(flicker == 2) then theScene:blit(x,y,donut2)end
    if(flicker == 3) then theScene:blit(x,y,donut3)end

	--move the trident
end


count=0
function doWater()
 count = count + 1
 if count >= 6 then
  dropx = math.ceil(math.random(WMAP_WIDTH-1)+1)
  dropy = math.ceil(math.random(WMAP_HEIGHT-1)+1)
  --print(tostring(dropx),tostring(dropy))
  watermap2[dropy][dropx] = -128;
  count = 0
 end
 water_tick()
 water_render()
end

--runs one frame of the selected effect
--effects will use the current image global 'theScene'
--and ideally will be nice and speedy ^_^
function runEffect(i)
   if(i==0)then
        doIntro();
   elseif(i==1)then
        drawSpikeyBall()
   elseif(i==2)then
        doWater()
   elseif(i==3)then
        doFire()
   elseif(i==4)then
        doDonut()   
   elseif(i==5)then
	doNDLOGO()
   elseif(i==6)then
	drawSpikeyBall()
   elseif(i==7)then
	doFire()
   elseif(i==8)then
	doCube()
   elseif (i==9) then
	drawSpikeyBall()	
   elseif (i==10) then
	doNDLOGO()	
   elseif (i==11) then
	drawSpikeyBall()	
   elseif (i==12) then
	doPatGroove()	
   elseif (i==13) then
	doPatGroove()	
   elseif (i==14) then
	drawSpikeyBall()	
   elseif (i==15) then
	drawSpikeyBall()	
   end

end

function initAllEffects()
	fire_init()
	water_init()
end


-- initial decays of 3D cube
userX = - 0.01
userY =  0.01

--bounce donut
    x = 1;
    dx=1;
    y=50;
    dy=10;
    ddy=-1;

    --scrolltxt
scrltxtx =30
scrltxty =262
chars=0
charscrlx=-100
charscrly=0

--guybrush = Image.load("guybrush.png")
background = Image.load("background.png")
patgroove = Image.load("lonnie.png")
--volumeBar = Image.load("volumeBar.png")
--topMost = Image.load("topMost.png")
pulse=0
wave=1
--main loop

iCurrentEffect=0--start with 
iFirstTimeVolume=1
iFirstTime=1;
initAllEffects()

--this a good one to start with
iMusicVolume=250;
--Music.playFile("OVERTHRUSTER_nordragc64.it", true)

while true do
    -- look for input
    keyboardControl()
	
    --fade the volume up the first time
    ----no, that's stupid
    --
--   if iFirstTimeVolume==1 then
--        iMusicVolume=iMusicVolume+1
--        if iMusicVolume > 200 then
--	    iFirstTimeVolume=0
--        end
--    end
    

    
    Music.volume(iMusicVolume)
    
    --display background image and volume bar
    theScene:fillRect(0, 0 , 480, 272, color.black)
  --  theScene:blit(480-(iMusicVolume*1.2 + pulse),80,volumeBar)

   -- if(iCurrentEffect == 3) then
    --  -- theScene:fillRect(0, 260 , 480, 272, color.black)
  --  else
       theScene:blit(0,0,background)
  --  end
    --bounce the volume bar
    --
--    pulse=pulse+10
  --  if wave==1 then
--	    if pulse > 30 then
--		    wave=2
--		    pulse=0
--	    end
--    end
--    if wave==2 then
--	    if pulse > 20 then
--		    wave=1
--		    pulse=0
--	    end
--    end
    
  

    --run effect after bottom most image blits
    --effects will keep their own global vars, will switch with time and song
    runEffect(iCurrentEffect)

    
    --display topmost image of image (underneath text)
   -- theScene:blit(0,149,topMost)

   -- for inspiration
   -- theScene:print(300,70,"vvvvv  VOLUME BAR  vvvvv",color.white)
   -- theScene:print(0,70,"Linsday Lohan <3 <3",color.red)
   
   -- if iCurrentEffect == 1 then theScene:print(240,120,"FiYAH",color.white) end
   -- if iCurrentEffect == 2 then theScene:print(240,120,"Cube!!",color.green) end
   -- if iCurrentEffect == 3 then theScene:print(240,120,"Flaming jelly donut!!",color.red) end
    

--scrollers suck
    if(charscrlx>=8)then
	   charscrlx=0
	   if(chars >= scrolltextLen[iCurrentSong]) then
		    chars = 0
		    charscrlx=-480
	   else    
		    chars = chars +1
 	   end
    else
	    charscrlx=charscrlx+4
    end
    
--hack
    --if(iCurrentEffect==LONNIE)then 
    --    theScene:print(8-charscrlx,scrltxty,string.sub(scrolltext[LONNIETEXT],chars),color.green)
    --else
    --    theScene:print(8-charscrlx,scrltxty,string.sub(scrolltext[iCurrentSong],chars),color.green)
    --end

--NOHAX!! take that haxx0rz
	theScene:print(8-charscrlx,scrltxty,string.sub(scrolltext[iCurrentSong],chars),color.green)
    -- display
 
--    theScene:print(0, 262,"ND PSP LUA workbench 2.0", color.green)
    if(iCurrentSong == 1)then
        theScene:print(10, 250,"Now playing - Modrn2 by bernielomax", color.green)
    elseif(iCurrentSong == 2)then
        theScene:print(10, 250,"Now playing - Hard Techno by overthruster", color.green)
    elseif(iCurrentSong == 3)then
        theScene:print(10, 250,"Now playing - Former by bernieLomax", color.green)
    elseif(iCurrentSong == 4)then
        theScene:print(10, 250,"Now playing - Xmxmndragon by overthruster", color.green)
    elseif(iCurrentSong == 5)then
        theScene:print(10, 250,"Now playing - Songforu by bernielomax", color.green)
    elseif(iCurrentSong == 6)then
        theScene:print(10, 250,"Now playing - Stor by bernielomax", color.green)
    elseif(iCurrentSong == 7)then
        theScene:print(10, 250,"Now playing - Pungent House by hardliner", color.green)
    elseif(iCurrentSong == 8)then
        theScene:print(10, 250,"Now playing - Nordragc64 by overthruster", color.green)
    elseif(iCurrentSong == 9)then
        theScene:print(10, 250,"Now playing - Skyline by soul d", color.green)
    elseif(iCurrentSong == 10)then
        theScene:print(10, 250,"Now playing - Dragorn by k9d", color.green)
    elseif(iCurrentSong == 11)then
        theScene:print(10, 250,"Now playing - iGNATZ - influenza", color.green)
    elseif(iCurrentSong == 12)then
        theScene:print(10, 250,"Now playing - Nordragc64 by overthruster", color.green)
    elseif(iCurrentSong == 13)then
        theScene:print(10, 250,"this is the secret part thing", color.green)
    end
 
    screen:blit(0, 0, theScene)
    screen.waitVblankStart()
    screen.flip()

    pad = Controls.read()
    if pad:start() then
	break
    end

end

