-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- NonConForm (c)kRadD  
-- -------------------
--    kradd@tscc.de
-- -------------------
-- lua library file
-- -------------------
-- Description: lua utility functions
-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++

-- ********************************************************
--- switch
-- impementation of the switch command
-- @selector: the variable that select the switch
-- @t: a table with the switches
-- @default: a function used by default

function switch(selector,t,default)
  assert(type(t)=="table","Table not supplied to switch")
  local f=t[selector]

  if f then
    assert(type(f)=="function","Not a function")
    f()
  else
    if type(default)=="function" then
      default()
    end
  end
end

-- ********************************************************
--- convtBoolToInt
-- Converts Boolean to int
-- @bool: the boolean value
-- @@: integer the integer value

function convertBoolToInt(bool)
	if bool==true then
		return 1;
	else
		return 0;
	end
end

-- ********************************************************
--- intervalues
-- Iterator over tables
-- @t: the table
-- @@: anything the table cell content

function itervalues(t)
	local i=0;

	return function() 
		i=i+1; 
		return t[i] 
	end
end

-- ********************************************************
--- non_DummyResults
-- fills the result table with data. Used to show some data
-- in the tournament table after in an initial code generation

function non_DummyResults()
	local counter;
	
	for counter=1,nonGlobals.nonNumberOfPlayers do
		nonGlobals.nonGameResults[counter].result=counter;
		nonGlobals.nonGameResults[counter].points=(nonGlobals.nonNumberOfPlayers+1)-counter;
	end
end

-- ********************************************************
--- non_DummyResult
-- fills the first result with a fixed value added by a random 
-- value of a given range
-- used to get different scores for the highscore table
-- @range: the range of the random the table
-- @fixvalue: a fixed value, the range will be added to

function non_DummyResult(range,fixvalue)
	nonGlobals.nonGameResults[1].result=1;
	nonGlobals.nonGameResults[1].points=math.random(range)+fixvalue;
end

-- ********************************************************
--- non_textcenter
-- center a text in the given box(x,width) 
-- @xstart: x position of the box the text should be centered in
-- @width: width of the box
-- @text: the text
-- @font: the font of the text
-- @@: the x position of the centered text

function non_centerText(arg_xstart,arg_width,arg_text,arg_font)
	local textlength=string.len(arg_text)*arg_font:getSpacing();
	
	return ((arg_width-textlength)/2)+arg_xstart;	
end
