-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- NonConForm (c)kRadD  
-- -------------------
--    kradd@tscc.de
-- -------------------
-- lua library file
-- -------------------
-- Description: lua input device functions
-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++

-- ********************************************************
--- non_directionControlling
-- move a sprite in his direction. Handle direction changes
-- via the controller
-- @model: the model
-- @pad: the pad object
-- @playerdirection: the actual direction
-- @sprite: the sprite object
-- @@: (integer): the new direction 

function non_directionControlling(model,pad,playerdirection,sprite)
	-- set direction
	if bitand(pad,NON_CONTROLLERUP)==NON_CONTROLLERUP and playerdirection~=NON_CONTROLLERDOWN then
		playerdirection=NON_CONTROLLERUP;
	elseif bitand(pad,NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN and playerdirection~=NON_CONTROLLERUP then
		playerdirection=NON_CONTROLLERDOWN;
	elseif bitand(pad,NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT and playerdirection~=NON_CONTROLLERRIGHT then
		playerdirection=NON_CONTROLLERLEFT;
	elseif bitand(pad,NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT and playerdirection~=NON_CONTROLLERLEFT then
		playerdirection=NON_CONTROLLERRIGHT;
	end

	-- move because of direction
	if playerdirection==NON_CONTROLLERUP then
		if sprite:getY()-model.controlls.ymove >= model.boundary[2] then 
			sprite:setY((sprite:getY())-model.controlls.ymove);
		end
	elseif playerdirection==NON_CONTROLLERDOWN then
		if sprite:getY()+model.controlls.ymove <= model.boundary[4] then 
			sprite:setY((sprite:getY())+model.controlls.ymove);
		end
	elseif playerdirection==NON_CONTROLLERLEFT then
		if sprite:getX()-model.controlls.xmove >= model.boundary[1] then 
			sprite:setX((sprite:getX())-model.controlls.xmove);
		end
	elseif playerdirection==NON_CONTROLLERRIGHT then
		if sprite:getX()+model.controlls.xmove <= model.boundary[3] then 
			sprite:setX((sprite:getX())+model.controlls.xmove);
		end
	end
	
	return playerdirection;
end

-- ********************************************************
--- non_moveControlling
-- move a sprite corresponding the controller
-- @model: the model
-- @pad: the pad object
-- @playerdirection: the actual direction
-- @sprite: the sprite object
-- @@: (integer): the new direction 

function non_moveControlling(model,pad,playerdirection,sprite)
	-- set direction
	if bitand(pad,NON_CONTROLLERUP)==NON_CONTROLLERUP then
		if sprite:getY()-model.controlls.ymove >= model.boundary[2] then 
			sprite:setY((sprite:getY())-model.controlls.ymove);
		end
		playerdirection=NON_CONTROLLERUP;
	elseif bitand(pad,NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN then
		if sprite:getY()+model.controlls.ymove <= model.boundary[4] then 
			sprite:setY((sprite:getY())+model.controlls.ymove);
		end
		playerdirection=NON_CONTROLLERDOWN;
	elseif bitand(pad,NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT then
		if sprite:getX()-model.controlls.xmove >= model.boundary[1] then 
			sprite:setX((sprite:getX())-model.controlls.xmove);
		end
		playerdirection=NON_CONTROLLERLEFT;
	elseif bitand(pad,NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT then
		if sprite:getX()+model.controlls.xmove <= model.boundary[3] then 
			sprite:setX((sprite:getX())+model.controlls.xmove);
		end
		playerdirection=NON_CONTROLLERRIGHT;
	end


	return playerdirection;
end

-- ********************************************************
--- non_waitKey
-- waits until the specified key is pressed
-- @key: the key

function non_waitKey(key)
	while nonInternals.nonKeyBoard:getKeyStatus(key)==false do
	end
end

-- ********************************************************
--- non_refreshControlls
-- - refresh the controllers<br>
-- - get the status of the masterpad<br>
-- - get the status of the masterpad keys<br>

function non_refreshControlls()
	nonInternals.nonControllers:refresh();
	nonInternals.nonMasterPad=nonInternals.nonControllers:getPacket(1);
	nonInternals.nonMasterPadKeys=nonInternals.nonControllers:getKeys(1);
end
		
-- ********************************************************
--- non_testControllPressed
-- tests if a buttons is pressed and/or the space key is pressed
-- @testpad: (true) pad is tested (false) pad is not tested
-- @mastermode: (true) test only pad 1 (false) test all pads
-- @testkey: (true) keyboard is tested (false) keyboard is not tested
-- @@: (boolean,boolean) pad is pressed (or not), space key is pressed (or not)

function non_testControllPressed(testpad,mastermode,testkey)
	local keypressed=false;
	local padpressed=false;
	local portcounter,controllercounter;

	if testpad==true then 
		if nonInternals.nonTeamTaps~=nil then
			if mastermode==true then
				nonInternals.nonControllers:refresh();

				if nonInternals.nonControllers:isButtonPressed(1,1)==true then
					nonInternals.nonControllers:waitButtonNotPressed(1,1);
					padpressed=true;
				end
			else
				for portcounter=1,2 do
					for controllercounter=1,4 do
						nonInternals.nonControllers:refresh();

						if nonInternals.nonControllers:isButtonPressed(portcounter,controllercounter)==true then
							nonInternals.nonControllers:waitButtonNotPressed(portcounter,controllercounter);		
							padpressed=true;
						end
					end
				end
			end
		elseif nonInternals.nonJagPads~=nil then
			if mastermode==true then
					if nonInternals.nonControllers:isButtonPressed(1)==true then
						padpressed=true;
					end
				else
					for portcounter=1,2 do
						if nonInternals.nonControllers:isButtonPressed(portcounter)==true then
							padpressed=true;
						end
					end
			end
		end
	end

	if testkey==true then
		keypressed=keyboard:getKeyStatus(NON_F030_KEY_SPACE);
	end

	return padpressed,keypressed;
end

-- ********************************************************
--- non_controllsEvents
-- detect standard controll based events:<br>
-- - F5: Screenshot<br>
-- - jagpad # and jagpad *: restart (back to first screen)
-- - jagpad option and jagpad pause: back to menu
-- @model: the model

function non_controllsEvents(model)
	keypressed,padpressed=non_testControllPressed(model.events.usePad,model.events.mastermode,model.events.useKeyBoard);
	
	if keypressed==true or padpressed==true then
		nonInternals.nonExitEvent=NON_NEXTEVENT;
	else
		-- +++ test pad events ++++++++++++++++++++++++++++++++
		if model.events.useInitEvent==true then
			if bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_STAR+NON_JAGPADKEY_HASH)==NON_JAGPADKEY_STAR+NON_JAGPADKEY_HASH then
				nonInternals.nonExitEvent=NON_INITEVENT;
			end
		end
		if model.events.useMenuEvent==true then
			if bitand(nonInternals.nonMasterPadKeys,NON_JAGPADKEY_PAUSE+NON_JAGPADKEY_OPTION)==NON_JAGPADKEY_PAUSE+NON_JAGPADKEY_OPTION then
				nonInternals.nonExitEvent=NON_MENUEVENT;
			end
		end
	
		-- +++ test key events +++++++++++++++++++++++++++++++
		if model.events.useScreenDump==true then
			if keyboard:getKeyStatus(NON_F030_KEY_F5) then
				nonsys:dumpScreenToFile(string.sub(model.stagename,1,5)); 
			end						
		end
	end
end