// Options:
//	- optTexture : writes the diffuse texture if true. Writes white if false.

float4x4 matProjViewMatrix;
float4x4 matWorldMatrix;


struct vInput{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};


struct vOutput{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};


vOutput vs_main(vInput input){
	vOutput Out;
	input.position = mul(input.position, matWorldMatrix);
	Out.position = mul(input.position, matProjViewMatrix);
	Out.tex = input.tex;

	return Out;
}


sampler diffuseTexture;


float4 ps_main(float4 tex: TEXCOORD0):COLOR0{
	if(optTexture)
		return float4(0,0,0,tex2D(diffuseTexture, tex).a);
	else
		return 0;
}

