/*
 *	Emissive Pass
 */
// Options:
//   optTextured : true the material has a emissive map. False, renders black.
float4x4 matViewProjMatrix;
float4x4 matWorldMatrix;

struct VS_INPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};


struct VS_OUTPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};


VS_OUTPUT vs_emissive(VS_INPUT input){
	VS_OUTPUT Out = (VS_OUTPUT)0;
	input.position = mul(input.position, matWorldMatrix);
	Out.position = mul(input.position, matViewProjMatrix);
	Out.tex = input.tex;
	return Out;
}


sampler diffuseMap;
sampler emissiveMap;


float4 ps_emissive(float2 tex: TEXCOORD):COLOR0{
	float alpha = tex2D(diffuseMap, tex).a;
	if(optTextured)
		return float4(tex2D(emissiveMap, tex).rgb, alpha);
	else
		return float4(0,0,0,alpha);
	//	return tex2D(diffuseMap, tex);
}



/*
 *	Glow
 */


float blur;
bool hdir;
float2 offset = float2(0,0);	// offset to center the glow to the image

struct VS_GLOWIN{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
};

struct VS_GLOWOUT 
{
	float4 Pos: POSITION;

	float2 tex1: TEXCOORD0;		//centro

	float2 tex2: TEXCOORD1;		//lado 1
	float2 tex3: TEXCOORD2;
	float2 tex4: TEXCOORD3;

	float2 tex5: TEXCOORD4;		//lado 2
	float2 tex6: TEXCOORD5;
	float2 tex7: TEXCOORD6;
};

VS_GLOWOUT vs_glow(VS_GLOWIN input)
{
	VS_GLOWOUT Out = (VS_GLOWOUT)0;

	Out.Pos = input.position;
	Out.tex1 = input.tex + hdir*0.01 + blur*0.01;

	if(hdir){

		Out.tex1 = input.tex + offset;

		Out.tex2 = input.tex + float2(blur*0.33,0) + offset;
		Out.tex3 = input.tex + float2(blur*0.66,0) + offset;
		Out.tex4 = input.tex + float2(blur*1.0,0) + offset;

		Out.tex5 = input.tex - float2(blur*0.33,0) + offset;
		Out.tex6 = input.tex - float2(blur*0.66,0) + offset;
		Out.tex7 = input.tex - float2(blur*1.0,0) + offset;

	}
	else{

		Out.tex1 = input.tex + offset;

		Out.tex2 = input.tex + float2(0,blur*0.33) + offset;
		Out.tex3 = input.tex + float2(0,blur*0.66) + offset;
		Out.tex4 = input.tex + float2(0,blur*1.0) + offset;

		Out.tex5 = input.tex - float2(0,blur*0.33) + offset;
		Out.tex6 = input.tex - float2(0,blur*0.66) + offset;
		Out.tex7 = input.tex - float2(0,blur*1.0) + offset;
	}

	return Out;
}


sampler glowMap;

struct PS_GLOWIN
{
	float2 tex1: TEXCOORD0;
	float2 tex2: TEXCOORD1;
	float2 tex3: TEXCOORD2;
	float2 tex4: TEXCOORD3;

	float2 tex5: TEXCOORD4;
	float2 tex6: TEXCOORD5;
	float2 tex7: TEXCOORD6;
};

float4 ps_glow(PS_GLOWIN input) : COLOR0
{
	float4 color = 0;
	color += tex2D(glowMap, input.tex1)*5;

	color += tex2D(glowMap, input.tex2)*3;
	color += tex2D(glowMap, input.tex3)*2;
	color += tex2D(glowMap, input.tex4)*1;

	color += tex2D(glowMap, input.tex5)*3;
	color += tex2D(glowMap, input.tex6)*2;
	color += tex2D(glowMap, input.tex7)*1;

	color /= 17;

	return color*1.1;
}


struct VS_INQUAD{
	float4 position: POSITION;
	float4 color: COLOR0;
};

struct VS_OUTQUAD{
	float4 position: POSITION;
	float4 color: COLOR0;
};


VS_OUTQUAD vs_quad(VS_INQUAD input){
	VS_OUTQUAD Out = (VS_OUTQUAD)0;
	Out.position = input.position;
	Out.color = input.color;
	return Out;
}


float4 ps_quad(float4 color:COLOR0):COLOR0{
	return color;
}