/*
	TUNAMI Shader
	coded by kioku@System K
*/

float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1x	:	TEXCOORD1;
	float2 Tex1y	:	TEXCOORD2;
	float3 E		:	TEXCOORD3;
	float4 N		:	COLOR0;
	float4 L		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	float4 amb = {0.2f,0.2f,0.2f,1.0f};//ArGg
	float3 YVec  = {0.01f,1.0f,0.01f};//YxNg
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	
	//ڃxNgƂ߂
	float3 B = normalize(cross(Nor,YVec));
	float3 T = normalize(cross(B,Nor));//ڃxNg
	B = normalize(cross(Nor,T));//]@xNg
	//ڋԂɕϊ
	float3 E = (EyePos-Pos).xyz;
	Out.E.x = dot(E,T);
	Out.E.y = dot(E,B);
	Out.E.z = dot(E,Nor);
	float3 L = -normalize(LightDir).xyz;
	Out.L.x = dot(L,T);
	Out.L.y = dot(L,B);
	Out.L.z = dot(L,Nor);
	//_PʂŌvZƂ
	Out.L.a  = float(max(0,dot(-LightDir,Nor))*0.8f+0.4f);
	Out.N = mul(Nor,mWVP);
	
	//eNX`Aj[V
	Out.Tex0 = Tex0;
	Out.Tex1x = Tex1;
	Out.Tex1y = Tex1;
	float tn = AnimTime*0.4f*(1.0f-Col.a)*(1.0f-Col.a);
	Out.N.a = (1.0f-Col.a);
	//Out.Tex1x = Tex1*0.1f + float2(tn, -tn);
	//Out.Tex1y = Tex1*0.02f + float2(-tn,-tn);
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float3 bumpX = 2.0f*tex2D(Samp1,In.Tex1x)-1.0f;
	float3 bumpY = 2.0f*tex2D(Samp1,In.Tex1y)-1.0f;
	float3 bump = normalize(bumpX+bumpY);
	float3 L = normalize(In.L.xyz);
	float3 R = normalize(reflect(-In.E, bump));
	float4 ref = max(0,dot(R, L));//ʔ
	float4 tex;
	//tex = tex2D(Samp0,In.Tex0 + bump.xy*0.5f)+max(0,dot(normalize(In.N),L))*0.2f + 0.1*pow(ref, 8);
	
	tex = tex2D(Samp0,In.Tex0 + bump.xy*In.N.a*0.5f*sin(AnimTime*20.0f));
	tex *= max(0,dot(normalize(In.N),L))*0.3f + 0.1*pow(ref, 8) + 0.3f;
	//tex = t*In.L.a+ 0.2*pow(ref, 8);
	tex.a = 0.6f;
	return tex;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS();
	}
}